/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.http.client;

import org.everrest.http.client.LinkElement;

class LinkedList {
    private LinkElement head = null;
    private LinkElement tail = null;
    private LinkElement next_enum = null;

    LinkedList() {
    }

    public synchronized void addToHead(Object elem) {
        this.head = new LinkElement(elem, this.head);
        if (this.head.next == null) {
            this.tail = this.head;
        }
    }

    public synchronized void addToEnd(Object elem) {
        if (this.head == null) {
            this.head = this.tail = new LinkElement(elem, null);
        } else {
            this.tail = this.tail.next = new LinkElement(elem, null);
        }
    }

    public synchronized void remove(Object elem) {
        if (this.head == null) {
            return;
        }
        if (this.head.element == elem) {
            this.head = this.head.next;
            return;
        }
        LinkElement curr = this.head;
        while (curr.next != null) {
            if (curr.next.element == elem) {
                if (curr.next == this.tail) {
                    this.tail = curr;
                }
                curr.next = curr.next.next;
                return;
            }
            curr = curr.next;
        }
    }

    public synchronized Object getFirst() {
        if (this.head == null) {
            return null;
        }
        return this.head.element;
    }

    public synchronized Object enumerate() {
        if (this.head == null) {
            return null;
        }
        this.next_enum = this.head.next;
        return this.head.element;
    }

    public synchronized Object next() {
        if (this.next_enum == null) {
            return null;
        }
        Object elem = this.next_enum.element;
        this.next_enum = this.next_enum.next;
        return elem;
    }

    public static void main(String[] args) throws Exception {
        System.err.println("\n*** Linked List Tests ...");
        LinkedList list = new LinkedList();
        list.addToHead("One");
        list.addToEnd("Last");
        if (!list.getFirst().equals("One")) {
            throw new Exception("First element wrong");
        }
        if (!list.enumerate().equals("One")) {
            throw new Exception("First element wrong");
        }
        if (!list.next().equals("Last")) {
            throw new Exception("Last element wrong");
        }
        if (list.next() != null) {
            throw new Exception("End of list wrong");
        }
        list.remove("One");
        if (!list.getFirst().equals("Last")) {
            throw new Exception("First element wrong");
        }
        list.remove("Last");
        if (list.getFirst() != null) {
            throw new Exception("End of list wrong");
        }
        list = new LinkedList();
        list.addToEnd("Last");
        list.addToHead("One");
        if (!list.getFirst().equals("One")) {
            throw new Exception("First element wrong");
        }
        if (!list.enumerate().equals("One")) {
            throw new Exception("First element wrong");
        }
        if (!list.next().equals("Last")) {
            throw new Exception("Last element wrong");
        }
        if (list.next() != null) {
            throw new Exception("End of list wrong");
        }
        if (!list.enumerate().equals("One")) {
            throw new Exception("First element wrong");
        }
        list.remove("One");
        if (!list.next().equals("Last")) {
            throw new Exception("Last element wrong");
        }
        list.remove("Last");
        if (list.next() != null) {
            throw new Exception("End of list wrong");
        }
        list = new LinkedList();
        list.addToEnd("Last");
        list.addToHead("Two");
        list.addToHead("One");
        if (!list.getFirst().equals("One")) {
            throw new Exception("First element wrong");
        }
        if (!list.enumerate().equals("One")) {
            throw new Exception("First element wrong");
        }
        if (!list.next().equals("Two")) {
            throw new Exception("Second element wrong");
        }
        if (!list.next().equals("Last")) {
            throw new Exception("Last element wrong");
        }
        if (list.next() != null) {
            throw new Exception("End of list wrong");
        }
        list.remove("Last");
        list.remove("Two");
        list.remove("One");
        if (list.getFirst() != null) {
            throw new Exception("Empty list wrong");
        }
        System.err.println("\n*** Tests finished successfuly");
    }
}

