/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.Filter;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;
import org.everrest.core.PerRequestObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.ApplicationPublisher;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.exoplatform.ApplicationConfiguration;
import org.everrest.exoplatform.ApplicationResource;

public class ExoApplicationPublisher
extends ApplicationPublisher {
    private final ResourceBinder resources;
    private final ProviderBinder providers;

    public ExoApplicationPublisher(ResourceBinder resources, ProviderBinder providers) {
        super(resources, providers);
        this.resources = resources;
        this.providers = providers;
    }

    public void publish(Application application) {
        if (application instanceof ApplicationConfiguration) {
            Set perRequests;
            ApplicationResource resource;
            String applicationName = ((ApplicationConfiguration)application).getApplicationName();
            Set singletons = application.getSingletons();
            ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
            if (singletons != null && !singletons.isEmpty()) {
                for (Object instance : singletons) {
                    Class clazz = instance.getClass();
                    if (clazz.getAnnotation(Provider.class) != null) {
                        if (instance instanceof ContextResolver) {
                            this.providers.addContextResolver((ContextResolver)instance);
                        }
                        if (instance instanceof ExceptionMapper) {
                            this.providers.addExceptionMapper((ExceptionMapper)instance);
                        }
                        if (instance instanceof MessageBodyReader) {
                            this.providers.addMessageBodyReader((MessageBodyReader)instance);
                        }
                        if (!(instance instanceof MessageBodyWriter)) continue;
                        this.providers.addMessageBodyWriter((MessageBodyWriter)instance);
                        continue;
                    }
                    if (clazz.getAnnotation(Filter.class) != null) {
                        if (instance instanceof MethodInvokerFilter) {
                            this.providers.addMethodInvokerFilter((MethodInvokerFilter)instance);
                        }
                        if (instance instanceof RequestFilter) {
                            this.providers.addRequestFilter((RequestFilter)instance);
                        }
                        if (!(instance instanceof ResponseFilter)) continue;
                        this.providers.addResponseFilter((ResponseFilter)instance);
                        continue;
                    }
                    if (clazz.getAnnotation(Path.class) == null) continue;
                    resource = new ApplicationResource(applicationName, clazz, ComponentLifecycleScope.SINGLETON);
                    resource.accept((ResourceDescriptorVisitor)rdv);
                    this.resources.addResource((ObjectFactory)new SingletonObjectFactory((ObjectModel)resource, instance));
                }
            }
            if ((perRequests = application.getClasses()) != null && !perRequests.isEmpty()) {
                for (Class clazz : perRequests) {
                    if (clazz.getAnnotation(Provider.class) != null) {
                        if (ContextResolver.class.isAssignableFrom(clazz)) {
                            this.providers.addContextResolver(clazz);
                        }
                        if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                            this.providers.addExceptionMapper(clazz);
                        }
                        if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                            this.providers.addMessageBodyReader(clazz);
                        }
                        if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                        this.providers.addMessageBodyWriter(clazz);
                        continue;
                    }
                    if (clazz.getAnnotation(Filter.class) != null) {
                        if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                            this.providers.addMethodInvokerFilter(clazz);
                        }
                        if (RequestFilter.class.isAssignableFrom(clazz)) {
                            this.providers.addRequestFilter(clazz);
                        }
                        if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                        this.providers.addResponseFilter(clazz);
                        continue;
                    }
                    if (clazz.getAnnotation(Path.class) == null) continue;
                    resource = new ApplicationResource(applicationName, clazz, ComponentLifecycleScope.PER_REQUEST);
                    resource.accept((ResourceDescriptorVisitor)rdv);
                    this.resources.addResource((ObjectFactory)new PerRequestObjectFactory((ObjectModel)resource));
                }
            }
        } else {
            super.publish(application);
        }
    }
}

