/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollector;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.LifecycleComponent;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.async.AsynchronousProcessListWriter;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.util.Logger;
import org.everrest.exoplatform.EverrestConfigurationHelper;
import org.everrest.exoplatform.ExoAsynchronousJobPool;
import org.everrest.exoplatform.StartableApplication;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.picocontainer.Startable;

public class EverrestInitializer
implements Startable {
    private static final Logger LOG = Logger.getLogger(EverrestInitializer.class);
    private final ExoContainer container;
    private final EverrestConfiguration config;
    private final EverrestProcessor processor;
    private List<WeakReference<Object>> singletonsReferences;

    public EverrestInitializer(ExoContainerContext containerContext, EverrestProcessor processor, StartableApplication eXo, InitParams initParams) {
        this.processor = processor;
        this.container = containerContext.getContainer();
        this.config = EverrestConfigurationHelper.createEverrestConfiguration(initParams);
    }

    public void start() {
        EverrestApplication everrest = new EverrestApplication();
        if (this.config.isAsynchronousSupported()) {
            everrest.addSingleton((Object)new ExoAsynchronousJobPool(this.config));
            everrest.addSingleton((Object)new AsynchronousProcessListWriter());
            everrest.addClass(AsynchronousJobService.class);
        }
        if (this.config.isCheckSecurity()) {
            everrest.addSingleton((Object)new SecurityConstraint());
        }
        Set singletons = everrest.getSingletons();
        this.singletonsReferences = new ArrayList<WeakReference<Object>>(singletons.size());
        for (Object o : singletons) {
            this.singletonsReferences.add(new WeakReference(o));
        }
        this.processor.addApplication((Application)everrest);
        List allApps = this.container.getComponentInstancesOfType(Application.class);
        if (allApps != null && !allApps.isEmpty()) {
            for (Object o : allApps) {
                this.processor.addApplication((Application)o);
            }
        }
    }

    public void stop() {
        this.makeFileCollectorDestroyer().stopFileCollector();
        if (this.singletonsReferences != null && this.singletonsReferences.size() > 0) {
            for (WeakReference<Object> ref : this.singletonsReferences) {
                Object o = ref.get();
                if (o == null) continue;
                try {
                    new LifecycleComponent(o).destroy();
                }
                catch (InternalException e) {
                    LOG.error("Unable to destroy component. ", (Throwable)e);
                }
            }
            this.singletonsReferences.clear();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer(){

            public void stopFileCollector() {
                FileCollector fc = FileCollector.getInstance();
                fc.stop();
            }
        };
    }
}

