/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.guice;

import com.google.inject.Key;
import java.lang.annotation.Annotation;
import org.everrest.guice.BindingPath;

public class ServiceBindingHelper {
    private ServiceBindingHelper() {
    }

    public static <T> Key<T> bindingKey(Class<T> clazz, String path) {
        return Key.get(clazz, (Annotation)new BindingPathImpl(path));
    }

    static class BindingPathImpl
    implements BindingPath {
        private final String value;

        BindingPathImpl(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return BindingPath.class;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BindingPath && this.value.equals(((BindingPath)o).value());
        }

        @Override
        public String toString() {
            return "@BindingPath('" + this.value + "')";
        }
    }
}

