/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.pico;

import java.util.Collection;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.servlet.EverrestApplication;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.pico.PicoDependencySupplier;
import org.everrest.pico.PicoObjectFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.web.WebappComposer;
import org.picocontainer.web.script.ScriptedWebappComposer;

public class EverrestComposer
implements WebappComposer {
    protected ApplicationProviderBinder providers;
    protected ResourceBinder resources;
    private ScriptedWebappComposer scriptedComposer;
    private String sessionScript;
    private String requestScript;

    public final void composeApplication(MutablePicoContainer container, ServletContext servletContext) {
        String containerBuilder;
        String applicationScript = servletContext.getInitParameter("application-script");
        if (applicationScript == null) {
            applicationScript = "pico-application.xml";
        }
        this.sessionScript = servletContext.getInitParameter("session-script");
        if (this.sessionScript == null) {
            this.sessionScript = "pico-session.xml";
        }
        this.requestScript = servletContext.getInitParameter("request-script");
        if (this.requestScript == null) {
            this.requestScript = "pico-request.xml";
        }
        if ((containerBuilder = servletContext.getInitParameter("scripted-container-builder")) == null) {
            containerBuilder = "org.picocontainer.script.xml.XMLContainerBuilder";
        }
        this.scriptedComposer = new ScriptedWebappComposer(containerBuilder, applicationScript, this.sessionScript, this.requestScript);
        if (this.isResourceAvailable(applicationScript)) {
            this.scriptedComposer.composeApplication(container, servletContext);
        }
        EverrestServletContextInitializer everrestInitializer = new EverrestServletContextInitializer(servletContext);
        this.resources = (ResourceBinder)container.getComponent(ResourceBinder.class);
        this.providers = (ApplicationProviderBinder)container.getComponent(ApplicationProviderBinder.class);
        EverrestConfiguration config = (EverrestConfiguration)container.getComponent(EverrestConfiguration.class);
        Object dependencySupplier = (DependencySupplier)container.getComponent(DependencySupplier.class);
        if (this.resources == null) {
            this.resources = new ResourceBinderImpl();
            container.addComponent(ResourceBinder.class, (Object)this.resources, new Parameter[0]);
        }
        if (this.providers == null) {
            this.providers = new ApplicationProviderBinder();
            container.addComponent(ApplicationProviderBinder.class, (Object)this.providers, new Parameter[0]);
        }
        if (config == null) {
            config = everrestInitializer.getConfiguration();
            container.addComponent(EverrestConfiguration.class, (Object)config, new Parameter[0]);
        }
        if (dependencySupplier == null) {
            dependencySupplier = new PicoDependencySupplier();
            container.addComponent(DependencySupplier.class, dependencySupplier, new Parameter[0]);
        }
        Application application = everrestInitializer.getApplication();
        EverrestApplication everrest = new EverrestApplication(config);
        everrest.addApplication(application);
        EverrestProcessor processor = new EverrestProcessor(this.resources, (ProviderBinder)this.providers, dependencySupplier, config, (Application)everrest);
        container.addComponent((Object)new PicoEverrestProcessorDestroyer(processor));
        container.addComponent((Object)new PicoFileCollectorDestroyer(this.makeFileCollectorDestroyer()));
        servletContext.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        servletContext.setAttribute(DependencySupplier.class.getName(), dependencySupplier);
        servletContext.setAttribute(ResourceBinder.class.getName(), (Object)this.resources);
        servletContext.setAttribute(ApplicationProviderBinder.class.getName(), (Object)this.providers);
        servletContext.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
        this.doComposeApplication(container, servletContext);
        this.processComponents(container, Scope.APPLICATION);
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    public final void composeSession(MutablePicoContainer container) {
        if (this.isResourceAvailable(this.sessionScript)) {
            this.scriptedComposer.composeSession(container);
        }
        this.doComposeSession(container);
        this.processComponents(container, Scope.SESSION);
    }

    public final void composeRequest(MutablePicoContainer container) {
        if (this.isResourceAvailable(this.requestScript)) {
            this.scriptedComposer.composeRequest(container);
        }
        this.doComposeRequest(container);
        this.processComponents(container, Scope.REQUEST);
    }

    private boolean isResourceAvailable(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    protected void doComposeApplication(MutablePicoContainer container, ServletContext servletContext) {
    }

    protected void doComposeRequest(MutablePicoContainer container) {
    }

    protected void doComposeSession(MutablePicoContainer container) {
    }

    protected void processComponents(MutablePicoContainer container, Scope scope) {
        ComponentLifecycleScope lifeCycle = scope == Scope.REQUEST ? ComponentLifecycleScope.PER_REQUEST : ComponentLifecycleScope.SINGLETON;
        Collection adapters = container.getComponentAdapters();
        ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
        for (ComponentAdapter adapter : adapters) {
            Class clazz = adapter.getComponentImplementation();
            if (clazz.getAnnotation(Provider.class) != null) {
                ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(clazz, lifeCycle);
                pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                if (ContextResolver.class.isAssignableFrom(clazz)) {
                    this.providers.addContextResolver(new PicoObjectFactory<ProviderDescriptorImpl>(pDescriptor));
                }
                if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                    this.providers.addExceptionMapper(new PicoObjectFactory<ProviderDescriptorImpl>(pDescriptor));
                }
                if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                    this.providers.addMessageBodyReader(new PicoObjectFactory<ProviderDescriptorImpl>(pDescriptor));
                }
                if (!MessageBodyWriter.class.isAssignableFrom(clazz)) continue;
                this.providers.addMessageBodyWriter(new PicoObjectFactory<ProviderDescriptorImpl>(pDescriptor));
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(clazz, lifeCycle);
                fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                    this.providers.addMethodInvokerFilter(new PicoObjectFactory<FilterDescriptorImpl>(fDescriptor));
                }
                if (RequestFilter.class.isAssignableFrom(clazz)) {
                    this.providers.addRequestFilter(new PicoObjectFactory<FilterDescriptorImpl>(fDescriptor));
                }
                if (!ResponseFilter.class.isAssignableFrom(clazz)) continue;
                this.providers.addResponseFilter(new PicoObjectFactory<FilterDescriptorImpl>(fDescriptor));
                continue;
            }
            if (clazz.getAnnotation(Path.class) == null) continue;
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(clazz, lifeCycle);
            descriptor.accept((ResourceDescriptorVisitor)rdv);
            this.resources.addResource(new PicoObjectFactory<AbstractResourceDescriptorImpl>(descriptor));
        }
    }

    private static final class PicoFileCollectorDestroyer
    implements Disposable {
        private final FileCollectorDestroyer fileCollectorDestroyer;

        public PicoFileCollectorDestroyer(FileCollectorDestroyer fileCollectorDestroyer) {
            this.fileCollectorDestroyer = fileCollectorDestroyer;
        }

        public void dispose() {
            this.fileCollectorDestroyer.stopFileCollector();
        }
    }

    private static final class PicoEverrestProcessorDestroyer
    implements Disposable {
        private final EverrestProcessor processor;

        private PicoEverrestProcessorDestroyer(EverrestProcessor processor) {
            this.processor = processor;
        }

        public void dispose() {
            this.processor.stop();
        }
    }

    public static enum Scope {
        APPLICATION,
        SESSION,
        REQUEST;

    }
}

