/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.pico;

import java.util.Collection;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.async.AsynchronousProcessListWriter;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.pico.PicoDependencySupplier;
import org.everrest.pico.PicoObjectFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.Startable;
import org.picocontainer.web.WebappComposer;
import org.picocontainer.web.script.ScriptedWebappComposer;

public class EverrestComposer
implements WebappComposer {
    private ScriptedWebappComposer scriptedComposer;
    private String sessionScript;
    private String requestScript;
    protected EverrestProcessor processor;

    public final void composeApplication(MutablePicoContainer container, ServletContext servletContext) {
        String containerBuilder;
        String applicationScript = servletContext.getInitParameter("application-script");
        if (applicationScript == null) {
            applicationScript = "pico-application.xml";
        }
        this.sessionScript = servletContext.getInitParameter("session-script");
        if (this.sessionScript == null) {
            this.sessionScript = "pico-session.xml";
        }
        this.requestScript = servletContext.getInitParameter("request-script");
        if (this.requestScript == null) {
            this.requestScript = "pico-request.xml";
        }
        if ((containerBuilder = servletContext.getInitParameter("scripted-container-builder")) == null) {
            containerBuilder = "org.picocontainer.script.xml.XMLContainerBuilder";
        }
        this.scriptedComposer = new ScriptedWebappComposer(containerBuilder, applicationScript, this.sessionScript, this.requestScript);
        if (this.isResourceAvailable(applicationScript)) {
            this.scriptedComposer.composeApplication(container, servletContext);
        }
        EverrestServletContextInitializer everrestInitializer = new EverrestServletContextInitializer(servletContext);
        ResourceBinder resources = (ResourceBinder)container.getComponent(ResourceBinder.class);
        ApplicationProviderBinder providers = (ApplicationProviderBinder)container.getComponent(ApplicationProviderBinder.class);
        EverrestConfiguration config = (EverrestConfiguration)container.getComponent(EverrestConfiguration.class);
        Object dependencySupplier = (DependencySupplier)container.getComponent(DependencySupplier.class);
        if (resources == null) {
            resources = new ResourceBinderImpl();
            container.addComponent(ResourceBinder.class, (Object)resources, new Parameter[0]);
        }
        if (providers == null) {
            providers = new ApplicationProviderBinder();
            container.addComponent(ApplicationProviderBinder.class, (Object)providers, new Parameter[0]);
        }
        if (config == null) {
            config = everrestInitializer.getConfiguration();
            container.addComponent(EverrestConfiguration.class, (Object)config, new Parameter[0]);
        }
        if (dependencySupplier == null) {
            dependencySupplier = new PicoDependencySupplier();
            container.addComponent(DependencySupplier.class, dependencySupplier, new Parameter[0]);
        }
        Application application = everrestInitializer.getApplication();
        EverrestApplication everrest = new EverrestApplication();
        if (config.isAsynchronousSupported()) {
            everrest.addResource(config.getAsynchronousServicePath(), AsynchronousJobService.class);
            everrest.addSingleton((Object)new AsynchronousJobPool(config));
            everrest.addSingleton((Object)new AsynchronousProcessListWriter());
        }
        if (config.isCheckSecurity()) {
            everrest.addSingleton((Object)new SecurityConstraint());
        }
        everrest.addApplication(application);
        this.doComposeApplication(container, servletContext);
        this.processComponents(container, everrest);
        this.processor = new EverrestProcessor(resources, (ProviderBinder)providers, dependencySupplier, config, (Application)everrest);
        container.addComponent((Object)new PicoEverrestProcessorWrapper(this.processor));
        container.addComponent((Object)new PicoFileCollectorDestroyer(this.makeFileCollectorDestroyer()));
        servletContext.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        servletContext.setAttribute(Application.class.getName(), (Object)everrest);
        servletContext.setAttribute(DependencySupplier.class.getName(), dependencySupplier);
        servletContext.setAttribute(ResourceBinder.class.getName(), (Object)resources);
        servletContext.setAttribute(ApplicationProviderBinder.class.getName(), (Object)providers);
        servletContext.setAttribute(EverrestProcessor.class.getName(), (Object)this.processor);
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    public final void composeSession(MutablePicoContainer container) {
        if (this.isResourceAvailable(this.sessionScript)) {
            this.scriptedComposer.composeSession(container);
        }
        this.doComposeSession(container);
        EverrestApplication sesEverrest = new EverrestApplication();
        this.processComponents(container, sesEverrest);
        this.processor.addApplication((Application)sesEverrest);
    }

    public final void composeRequest(MutablePicoContainer container) {
        if (this.isResourceAvailable(this.requestScript)) {
            this.scriptedComposer.composeRequest(container);
        }
        this.doComposeRequest(container);
        EverrestApplication reqEverrest = new EverrestApplication();
        this.processComponents(container, reqEverrest);
        this.processor.addApplication((Application)reqEverrest);
    }

    private boolean isResourceAvailable(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    protected void doComposeApplication(MutablePicoContainer container, ServletContext servletContext) {
    }

    protected void doComposeRequest(MutablePicoContainer container) {
    }

    protected void doComposeSession(MutablePicoContainer container) {
    }

    protected void processComponents(MutablePicoContainer container, EverrestApplication everrest) {
        Collection adapters = container.getComponentAdapters();
        ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
        for (ComponentAdapter adapter : adapters) {
            Class clazz = adapter.getComponentImplementation();
            if (clazz.getAnnotation(Provider.class) != null) {
                ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(clazz);
                pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                everrest.addFactory(new PicoObjectFactory<ProviderDescriptorImpl>(pDescriptor));
                continue;
            }
            if (clazz.getAnnotation(Filter.class) != null) {
                FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(clazz);
                fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                everrest.addFactory(new PicoObjectFactory<FilterDescriptorImpl>(fDescriptor));
                continue;
            }
            if (clazz.getAnnotation(Path.class) == null) continue;
            AbstractResourceDescriptorImpl rDescriptor = new AbstractResourceDescriptorImpl(clazz);
            rDescriptor.accept((ResourceDescriptorVisitor)rdv);
            everrest.addFactory(new PicoObjectFactory<AbstractResourceDescriptorImpl>(rDescriptor));
        }
    }

    private static final class PicoFileCollectorDestroyer
    implements Disposable {
        private final FileCollectorDestroyer fileCollectorDestroyer;

        public PicoFileCollectorDestroyer(FileCollectorDestroyer fileCollectorDestroyer) {
            this.fileCollectorDestroyer = fileCollectorDestroyer;
        }

        public void dispose() {
            this.fileCollectorDestroyer.stopFileCollector();
        }
    }

    private static final class PicoEverrestProcessorWrapper
    implements Startable {
        private final EverrestProcessor processor;

        private PicoEverrestProcessorWrapper(EverrestProcessor processor) {
            this.processor = processor;
        }

        public void start() {
            this.processor.start();
        }

        public void stop() {
            this.processor.stop();
        }
    }
}

