/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.spring;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.DependencySupplier;
import org.everrest.core.Filter;
import org.everrest.core.InitialProperties;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.FilterDescriptorImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.provider.ProviderDescriptorImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.servlet.EverrestApplication;
import org.everrest.spring.SpringObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

public class SpringComponentsLoader
implements BeanFactoryPostProcessor,
HandlerMapping {
    protected ResourceBinder resources;
    protected ApplicationProviderBinder providers;
    protected EverrestProcessor processor;
    protected EverrestConfiguration configuration;

    public SpringComponentsLoader(ResourceBinder resources, ApplicationProviderBinder providers, DependencySupplier dependencies) {
        this(resources, providers, new EverrestConfiguration(), dependencies);
    }

    public SpringComponentsLoader(ResourceBinder resources, ApplicationProviderBinder providers, EverrestConfiguration configuration, DependencySupplier dependencies) {
        this.resources = resources;
        this.providers = providers;
        this.configuration = configuration;
        this.processor = new EverrestProcessor(resources, (ProviderBinder)providers, dependencies, configuration, null);
    }

    protected SpringComponentsLoader() {
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        return new HandlerExecutionChain((Object)this.processor);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerSingleton("org.everrest.lifecycle.SpringEverrestProcessorDestroyer", (Object)new SpringEverrestProcessorDestroyer(this.processor));
        beanFactory.registerSingleton("org.everrest.lifecycle.SpringFileCollectorDestroyer", (Object)new SpringFileCollectorDestroyer(this.makeFileCollectorDestroyer()));
        this.processor.addApplication((Application)this.makeEverrestApplication());
        ResourceDescriptorValidator rdv = ResourceDescriptorValidator.getInstance();
        this.addAutowiredDependencies(beanFactory);
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            ComponentLifecycleScope lifeCycle;
            Class beanClass = beanFactory.getType(beanName);
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            ComponentLifecycleScope componentLifecycleScope = lifeCycle = beanDefinition.isPrototype() ? ComponentLifecycleScope.PER_REQUEST : ComponentLifecycleScope.SINGLETON;
            if (beanClass.getAnnotation(Provider.class) != null) {
                ProviderDescriptorImpl pDescriptor = new ProviderDescriptorImpl(beanClass, lifeCycle);
                pDescriptor.accept((ResourceDescriptorVisitor)rdv);
                if (ContextResolver.class.isAssignableFrom(beanClass)) {
                    this.providers.addContextResolver(new SpringObjectFactory<ProviderDescriptorImpl>(pDescriptor, beanName, (BeanFactory)beanFactory));
                }
                if (ExceptionMapper.class.isAssignableFrom(beanClass)) {
                    this.providers.addExceptionMapper(new SpringObjectFactory<ProviderDescriptorImpl>(pDescriptor, beanName, (BeanFactory)beanFactory));
                }
                if (MessageBodyReader.class.isAssignableFrom(beanClass)) {
                    this.providers.addMessageBodyReader(new SpringObjectFactory<ProviderDescriptorImpl>(pDescriptor, beanName, (BeanFactory)beanFactory));
                }
                if (!MessageBodyWriter.class.isAssignableFrom(beanClass)) continue;
                this.providers.addMessageBodyWriter(new SpringObjectFactory<ProviderDescriptorImpl>(pDescriptor, beanName, (BeanFactory)beanFactory));
                continue;
            }
            if (beanClass.getAnnotation(Filter.class) != null) {
                FilterDescriptorImpl fDescriptor = new FilterDescriptorImpl(beanClass, lifeCycle);
                fDescriptor.accept((ResourceDescriptorVisitor)rdv);
                if (MethodInvokerFilter.class.isAssignableFrom(beanClass)) {
                    this.providers.addMethodInvokerFilter(new SpringObjectFactory<FilterDescriptorImpl>(fDescriptor, beanName, (BeanFactory)beanFactory));
                }
                if (RequestFilter.class.isAssignableFrom(beanClass)) {
                    this.providers.addRequestFilter(new SpringObjectFactory<FilterDescriptorImpl>(fDescriptor, beanName, (BeanFactory)beanFactory));
                }
                if (!ResponseFilter.class.isAssignableFrom(beanClass)) continue;
                this.providers.addResponseFilter(new SpringObjectFactory<FilterDescriptorImpl>(fDescriptor, beanName, (BeanFactory)beanFactory));
                continue;
            }
            if (beanClass.getAnnotation(Path.class) == null) continue;
            AbstractResourceDescriptorImpl rDescriptor = new AbstractResourceDescriptorImpl(beanClass, lifeCycle);
            rDescriptor.accept((ResourceDescriptorVisitor)rdv);
            this.resources.addResource(new SpringObjectFactory<AbstractResourceDescriptorImpl>(rDescriptor, beanName, (BeanFactory)beanFactory));
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    protected EverrestApplication makeEverrestApplication() {
        return new EverrestApplication(this.configuration);
    }

    protected void addAutowiredDependencies(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerResolvableDependency(HttpHeaders.class, (Object)new ObjectFactory<HttpHeaders>(){

            public HttpHeaders getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getHttpHeaders();
            }
        });
        beanFactory.registerResolvableDependency(InitialProperties.class, (Object)new ObjectFactory<InitialProperties>(){

            public InitialProperties getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getInitialProperties();
            }
        });
        beanFactory.registerResolvableDependency(Request.class, (Object)new ObjectFactory<Request>(){

            public Request getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getRequest();
            }
        });
        beanFactory.registerResolvableDependency(SecurityContext.class, (Object)new ObjectFactory<SecurityContext>(){

            public SecurityContext getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getSecurityContext();
            }
        });
        beanFactory.registerResolvableDependency(UriInfo.class, (Object)new ObjectFactory<UriInfo>(){

            public UriInfo getObject() {
                ApplicationContext context = ApplicationContextImpl.getCurrent();
                if (context == null) {
                    throw new IllegalStateException("EverRest ApplicationContext is not initialized.");
                }
                return context.getUriInfo();
            }
        });
    }

    protected ResourceBinder getResources() {
        return this.resources;
    }

    protected ApplicationProviderBinder getProviders() {
        return this.providers;
    }

    protected EverrestProcessor getProcessor() {
        return this.processor;
    }

    private static final class SpringFileCollectorDestroyer
    extends Destroyer {
        private final FileCollectorDestroyer fileCollectorDestroyer;

        public SpringFileCollectorDestroyer(FileCollectorDestroyer fileCollectorDestroyer) {
            this.fileCollectorDestroyer = fileCollectorDestroyer;
        }

        public void stop() {
            this.fileCollectorDestroyer.stopFileCollector();
        }
    }

    private static final class SpringEverrestProcessorDestroyer
    extends Destroyer {
        private final EverrestProcessor processor;

        private SpringEverrestProcessorDestroyer(EverrestProcessor processor) {
            this.processor = processor;
        }

        public void stop() {
            this.processor.stop();
        }
    }

    private static abstract class Destroyer
    implements Lifecycle {
        private final AtomicBoolean started = new AtomicBoolean(true);

        private Destroyer() {
        }

        public final void start() {
        }

        public final boolean isRunning() {
            return this.started.get();
        }
    }
}

