/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.test.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class MockServletContext
implements ServletContext {
    private String name;
    private HashMap<String, String> initParams;
    private HashMap<String, Object> attributes;
    private String contextPath;
    private StringBuilder logBuffer = new StringBuilder();

    public MockServletContext() {
        this("MockServletContext1");
    }

    public MockServletContext(String name) {
        this.name = name;
        this.initParams = new HashMap();
        this.attributes = new HashMap();
    }

    public MockServletContext(String name, String path) {
        this(name);
        this.contextPath = path;
        this.attributes.put("javax.servlet.context.tempdir", path);
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogBuffer() {
        try {
            String string = this.logBuffer.toString();
            return string;
        }
        finally {
            this.logBuffer = new StringBuilder();
        }
    }

    public ServletContext getContext(String s) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String s) {
        return "text/html";
    }

    public Set getResourcePaths(String s) {
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        HashSet<String> set = new HashSet<String>();
        try {
            File dir;
            URL url = this.getResource(s);
            if (url != null && (dir = new File(url.getPath())).isDirectory()) {
                File[] arr = dir.listFiles();
                for (int i = 0; i < arr.length; ++i) {
                    File tmp = arr[i];
                    if (tmp.isDirectory()) {
                        set.add(s + "/" + tmp.getName() + "/");
                        continue;
                    }
                    set.add(s + "/" + tmp.getName());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return set;
    }

    public URL getResource(String s) throws MalformedURLException {
        String path = "file:" + this.contextPath + s;
        URL url = new URL(path);
        return url;
    }

    public InputStream getResourceAsStream(String s) {
        try {
            return this.getResource(s).openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return null;
    }

    @Deprecated
    public Servlet getServlet(String s) throws ServletException {
        return null;
    }

    @Deprecated
    public Enumeration getServlets() {
        return null;
    }

    @Deprecated
    public Enumeration getServletNames() {
        return null;
    }

    public void log(String s) {
        this.logBuffer.append(s);
    }

    @Deprecated
    public void log(Exception e, String s) {
        this.logBuffer.append(s).append(e.getMessage());
    }

    public void log(String s, Throwable throwable) {
        this.logBuffer.append(s).append(throwable.getMessage());
    }

    public void setContextPath(String s) {
        this.contextPath = s;
    }

    public String getRealPath(String s) {
        return this.contextPath + s;
    }

    public String getServerInfo() {
        return null;
    }

    public void setInitParameter(String name, String value) {
        this.initParams.put(name, value);
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        Vector<String> keys = new Vector<String>(this.initParams.keySet());
        return keys.elements();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        Vector<String> keys = new Vector<String>(this.attributes.keySet());
        return keys.elements();
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.name;
    }
}

