/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.test.mock;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.everrest.test.mock.CaseInsensitiveMultivaluedMap;

public class MockHttpServletResponse
implements HttpServletResponse {
    private PrintWriter writer;
    private ByteArrayOutputStream stream;
    private ByteArrayServletOutputStream output;
    private byte[] buffer = new byte[1024];
    private int bufferCount = 0;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private CaseInsensitiveMultivaluedMap<String> headers = new CaseInsensitiveMultivaluedMap();
    private int status = 200;
    private String message = "";
    private Locale locale = Locale.getDefault();
    private String contentType = null;
    protected int contentLength = -1;
    protected String encoding = null;
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public MockHttpServletResponse() {
        this.stream = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.stream);
        this.output = new ByteArrayServletOutputStream(this.stream);
    }

    public String getOutputContent() {
        return new String(this.stream.toByteArray());
    }

    public void flushBuffer() throws IOException {
        if (this.bufferCount > 0) {
            try {
                this.output.write(this.buffer, 0, this.bufferCount);
            }
            finally {
                this.bufferCount = 0;
            }
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.bufferCount = 0;
    }

    public void resetBuffer() {
        this.bufferCount = 0;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, format.format(new Date(value)));
    }

    public void addHeader(String name, String value) {
        this.headers.get(name).add(value);
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, "");
    }

    public void sendError(int status, String message) throws IOException {
        this.status = status;
        this.message = message;
        this.resetBuffer();
    }

    public void sendRedirect(String location) throws IOException {
        this.resetBuffer();
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long value) {
        this.setHeader(name, format.format(new Date(value)));
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, (List<String>)values);
        String lowerCaseName = name.toLowerCase();
        if (lowerCaseName.equals("content-length")) {
            int contentLength = Integer.parseInt(value);
            if (contentLength >= 0) {
                this.setContentLength(contentLength);
            }
        } else if (lowerCaseName.equals("content-type")) {
            this.setContentType(value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        return new ArrayList<String>((Collection<String>)this.headers.get(name));
    }

    public Collection<String> getHeaderNames() {
        return new ArrayList<String>(this.headers.keySet());
    }

    public String getCharacterEncoding() {
        return this.encoding == null ? "UTF-8" : this.encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setBufferSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        this.buffer = new byte[size];
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String encoding) {
        this.encoding = encoding;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        public ByteArrayServletOutputStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int i) throws IOException {
            this.baos.write(i);
        }
    }
}

