/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.tools.DummySecurityContext;
import org.everrest.core.util.Logger;
import org.everrest.websockets.WS2RESTAdapter;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionImpl;
import org.everrest.websockets.message.JsonMessageConverter;
import org.everrest.websockets.message.MessageConverter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EverrestWebSocketServlet
extends WebSocketServlet {
    public static final String EVERREST_PROCESSOR_ATTRIBUTE = EverrestProcessor.class.getName();
    public static final String PROVIDER_BINDER_ATTRIBUTE = ApplicationProviderBinder.class.getName();
    public static final String MESSAGE_CONVERTER_ATTRIBUTE = MessageConverter.class.getName();
    private static final Logger LOG = Logger.getLogger(EverrestWebSocketServlet.class);
    private EverrestProcessor processor;
    private AsynchronousJobPool asynchronousPool;
    private MessageConverter messageConverter;
    private final Collection<String> declaredRoles = new HashSet<String>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.processor = this.getEverrestProcessor();
        this.asynchronousPool = this.getAsynchronousJobPool();
        this.messageConverter = this.getMessageConverter();
        if (this.messageConverter == null) {
            this.messageConverter = new JsonMessageConverter();
        }
        try {
            this.declaredRoles.addAll(this.getApplicationDeclaredRoles());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected StreamInbound createWebSocketInbound(String s, HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        DummySecurityContext securityContext = null;
        if (principal != null) {
            HashSet<String> roles = new HashSet<String>();
            roles.addAll(this.declaredRoles);
            Iterator iterator = roles.iterator();
            while (iterator.hasNext()) {
                String role = (String)iterator.next();
                if (request.isUserInRole(role)) continue;
                iterator.remove();
            }
            securityContext = new DummySecurityContext(principal, roles);
        }
        WSConnectionImpl connection = WSConnectionContext.open(request.getSession().getId(), this.messageConverter);
        WS2RESTAdapter restAdapter = new WS2RESTAdapter(connection, (SecurityContext)securityContext, this.processor, this.asynchronousPool);
        WSConnectionContext.registerConnectionListener(restAdapter);
        connection.registerMessageReceiver(restAdapter);
        return connection;
    }

    protected EverrestProcessor getEverrestProcessor() {
        return (EverrestProcessor)this.getServletContext().getAttribute(EVERREST_PROCESSOR_ATTRIBUTE);
    }

    protected MessageConverter getMessageConverter() {
        return (MessageConverter)this.getServletContext().getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
    }

    protected AsynchronousJobPool getAsynchronousJobPool() {
        ContextResolver asyncJobsResolver;
        ProviderBinder providers = (ProviderBinder)this.getServletContext().getAttribute(PROVIDER_BINDER_ATTRIBUTE);
        if (providers != null && (asyncJobsResolver = providers.getContextResolver(AsynchronousJobPool.class, null)) != null) {
            return (AsynchronousJobPool)asyncJobsResolver.getContext(null);
        }
        throw new IllegalStateException("Unable get web socket connection. Asynchronous jobs feature is not configured properly. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getApplicationDeclaredRoles() throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        Document dom;
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        InputStream input = this.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
        try {
            dom = documentBuilder.parse(input);
        }
        finally {
            input.close();
        }
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        NodeList all = (NodeList)xpath.evaluate("/web-app/security-role/role-name", dom, XPathConstants.NODESET);
        int length = all.getLength();
        HashSet<String> result = new HashSet<String>(length);
        for (int i = 0; i < length; ++i) {
            result.add(all.item(i).getTextContent());
        }
        return result;
    }
}

