/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.UUID;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobListener;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.tools.SecurityContextRequest;
import org.everrest.core.util.Logger;
import org.everrest.websockets.EverrestResponseWriter;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSConnectionListener;
import org.everrest.websockets.WSMessageReceiver;
import org.everrest.websockets.message.InputMessage;
import org.everrest.websockets.message.MessageConversionException;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.Pair;
import org.everrest.websockets.message.RESTfulInputMessage;
import org.everrest.websockets.message.RESTfulOutputMessage;

class WS2RESTAdapter
implements WSMessageReceiver,
WSConnectionListener {
    private static final Logger LOG = Logger.getLogger(WS2RESTAdapter.class);
    private final SecurityContext securityContext;
    private final EverrestProcessor everrestProcessor;
    private final AsynchronousJobPool asynchronousPool;
    private WSConnection connection;

    WS2RESTAdapter(WSConnection connection, SecurityContext securityContext, EverrestProcessor everrestProcessor, AsynchronousJobPool asynchronousPool) {
        this.connection = connection;
        this.securityContext = securityContext;
        this.everrestProcessor = everrestProcessor;
        this.asynchronousPool = asynchronousPool;
    }

    @Override
    public void onOpen(WSConnection connection) {
    }

    @Override
    public void onClose(Long connectionId, int status) {
        if (this.connection.getConnectionId().equals(connectionId)) {
            this.connection = null;
        }
    }

    @Override
    public void onMessage(InputMessage input) {
        String requestPath;
        if (!(input instanceof RESTfulInputMessage)) {
            throw new IllegalArgumentException("Invalid input message. ");
        }
        final RESTfulInputMessage restInputMessage = (RESTfulInputMessage)input;
        MultivaluedMap<String, String> headers = Pair.toMap(restInputMessage.getHeaders());
        String messageType = (String)headers.getFirst((Object)"x-everrest-websocket-message-type");
        if ("ping".equalsIgnoreCase(messageType)) {
            RESTfulOutputMessage pong = this.newOutputMessage(restInputMessage);
            pong.setBody(restInputMessage.getBody());
            pong.setResponseCode(200);
            pong.setHeaders(new Pair[]{new Pair("x-everrest-websocket-message-type", "pong")});
            this.safeSendMessage(pong);
            return;
        }
        if ("subscribe-channel".equalsIgnoreCase(messageType) || "unsubscribe-channel".equalsIgnoreCase(messageType)) {
            String channel = this.parseSubscriptionMessage(input);
            RESTfulOutputMessage response = this.newOutputMessage(restInputMessage);
            response.setBody(restInputMessage.getBody());
            response.setHeaders(new Pair[]{new Pair("x-everrest-websocket-message-type", messageType)});
            if (channel != null) {
                this.checkConnection();
                if ("subscribe-channel".equalsIgnoreCase(messageType)) {
                    this.connection.subscribeToChannel(channel);
                } else {
                    this.connection.unsubscribeFromChannel(channel);
                }
                response.setResponseCode(200);
            } else {
                LOG.error("Invalid message: {} ", (Object)input.getBody());
                response.setResponseCode(400);
            }
            this.safeSendMessage(response);
            return;
        }
        final String internalUuid = UUID.randomUUID().toString();
        this.asynchronousPool.registerListener(new AsynchronousJobListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(AsynchronousJob job) {
                MultivaluedMap requestHeaders = ((ContainerRequest)job.getContext().get("org.everrest.async.request")).getRequestHeaders();
                if ("websocket".equals(requestHeaders.getFirst((Object)"x-everrest-protocol")) && internalUuid.equals(requestHeaders.getFirst((Object)"x-everrest-websocket-tracker-id"))) {
                    URI requestUri = UriBuilder.fromPath((String)("/async/" + job.getJobId())).build(new Object[0]);
                    SecurityContextRequest req = new SecurityContextRequest("GET", requestUri, URI.create(""), null, (MultivaluedMap)new InputHeadersMap(), WS2RESTAdapter.this.securityContext);
                    RESTfulOutputMessage output = WS2RESTAdapter.this.newOutputMessage(restInputMessage);
                    ContainerResponse resp = new ContainerResponse((ContainerResponseWriter)new EverrestResponseWriter(output));
                    try {
                        WS2RESTAdapter.this.everrestProcessor.process((GenericContainerRequest)req, (GenericContainerResponse)resp, new EnvironmentContext());
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        WS2RESTAdapter.this.asynchronousPool.unregisterListener((AsynchronousJobListener)this);
                    }
                    WS2RESTAdapter.this.safeSendMessage(output);
                }
            }
        });
        ByteArrayInputStream data = null;
        String body = input.getBody();
        if (body != null) {
            try {
                data = new ByteArrayInputStream(body.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        if (!(requestPath = restInputMessage.getPath()).startsWith("/")) {
            requestPath = "/" + requestPath;
        }
        URI requestUri = UriBuilder.fromUri((String)requestPath).build(new Object[0]);
        if (data != null) {
            headers.putSingle((Object)"content-length", (Object)Integer.toString(data.available()));
        }
        headers.putSingle((Object)"x-everrest-async", (Object)"true");
        headers.putSingle((Object)"x-everrest-protocol", (Object)"websocket");
        headers.putSingle((Object)"x-everrest-websocket-tracker-id", (Object)internalUuid);
        SecurityContextRequest req = new SecurityContextRequest(restInputMessage.getMethod(), requestUri, URI.create(""), (InputStream)data, (MultivaluedMap)new InputHeadersMap(headers), this.securityContext);
        RESTfulOutputMessage output = this.newOutputMessage(restInputMessage);
        ContainerResponse resp = new ContainerResponse((ContainerResponseWriter)new EverrestResponseWriter(output));
        try {
            this.everrestProcessor.process((GenericContainerRequest)req, (GenericContainerResponse)resp, new EnvironmentContext());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.safeSendMessage(output);
    }

    @Override
    public void onError(Exception error) {
        LOG.error(error.getMessage(), (Throwable)error);
    }

    private RESTfulOutputMessage newOutputMessage(RESTfulInputMessage input) {
        RESTfulOutputMessage output = new RESTfulOutputMessage();
        output.setUuid(input.getUuid());
        output.setMethod(input.getMethod());
        output.setPath(input.getPath());
        return output;
    }

    private void checkConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("Connection is closed. ");
        }
    }

    private void safeSendMessage(OutputMessage output) {
        this.checkConnection();
        try {
            this.connection.sendMessage(output);
        }
        catch (MessageConversionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private String parseSubscriptionMessage(InputMessage input) {
        JsonParser p = new JsonParser();
        try {
            p.parse((Reader)new StringReader(input.getBody()));
        }
        catch (JsonException e) {
            return null;
        }
        JsonValue jv = p.getJsonObject().getElement("channel");
        return jv != null ? jv.getStringValue() : null;
    }
}

