/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.WsOutbound;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionListener;
import org.everrest.websockets.WSMessageReceiver;
import org.everrest.websockets.message.MessageConversionException;
import org.everrest.websockets.message.MessageConverter;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.RESTfulInputMessage;

public class WSConnectionImpl
extends MessageInbound
implements WSConnection {
    private static final AtomicLong counter = new AtomicLong(1L);
    private static final Charset UTF8_CS = Charset.forName("UTF-8");
    private final long connectionId = counter.getAndIncrement();
    private final String httpSessionId;
    private final MessageConverter messageConverter;
    private final List<WSMessageReceiver> messageReceivers;
    private final Set<String> channels;
    private final Set<String> readOnlyChannels;

    WSConnectionImpl(String httpSessionId, MessageConverter messageConverter) {
        this.httpSessionId = httpSessionId;
        this.messageConverter = messageConverter;
        this.messageReceivers = new CopyOnWriteArrayList<WSMessageReceiver>();
        this.channels = new CopyOnWriteArraySet<String>();
        this.readOnlyChannels = Collections.unmodifiableSet(this.channels);
    }

    protected void onBinaryMessage(ByteBuffer message) throws IOException {
        this.getWsOutbound().close(1003, UTF8_CS.encode("Binary messages is not supported. "));
    }

    protected void onTextMessage(CharBuffer message) throws IOException {
        try {
            RESTfulInputMessage input = this.messageConverter.fromString(message.toString(), RESTfulInputMessage.class);
            for (WSMessageReceiver receiver : this.messageReceivers) {
                receiver.onMessage(input);
            }
        }
        catch (MessageConversionException e) {
            for (WSMessageReceiver receiver : this.messageReceivers) {
                receiver.onError(e);
            }
        }
    }

    protected void onOpen(WsOutbound outbound) {
        for (WSConnectionListener connectionListener : WSConnectionContext.connectionListeners) {
            connectionListener.onOpen(this);
        }
    }

    protected void onClose(int status) {
        for (WSConnectionListener connectionListener : WSConnectionContext.connectionListeners) {
            connectionListener.onClose(this.connectionId, status);
        }
    }

    @Override
    public Long getConnectionId() {
        return this.connectionId;
    }

    @Override
    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    @Override
    public boolean subscribeToChannel(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name may not be null. ");
        }
        return this.channels.add(channel);
    }

    @Override
    public boolean unsubscribeFromChannel(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name may not be null. ");
        }
        return this.channels.remove(channel);
    }

    @Override
    public Collection<String> getChannels() {
        return this.readOnlyChannels;
    }

    @Override
    public void close() throws IOException {
        this.getWsOutbound().close(1000, null);
    }

    @Override
    public void sendMessage(OutputMessage output) throws MessageConversionException, IOException {
        CharBuffer message = CharBuffer.wrap(this.messageConverter.toString(output));
        WsOutbound out = this.getWsOutbound();
        out.writeTextMessage(message);
        out.flush();
    }

    @Override
    public void registerMessageReceiver(WSMessageReceiver messageReceiver) {
        this.messageReceivers.add(messageReceiver);
    }

    @Override
    public void removeMessageReceiver(WSMessageReceiver messageReceiver) {
        this.messageReceivers.remove(messageReceiver);
    }

    public String toString() {
        return "WSConnectionImpl{connectionId=" + this.connectionId + ", httpSessionId='" + this.httpSessionId + '\'' + ", channels=" + this.channels + '}';
    }
}

