/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.security.Principal;
import java.util.LinkedHashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ContextResolver;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.tools.SimplePrincipal;
import org.everrest.core.tools.SimpleSecurityContext;
import org.everrest.core.tools.WebApplicationDeclaredRoles;
import org.everrest.websockets.WS2RESTAdapter;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionImpl;
import org.everrest.websockets.message.JsonMessageConverter;
import org.everrest.websockets.message.MessageConverter;

public class EverrestWebSocketServlet
extends WebSocketServlet {
    public static final String EVERREST_PROCESSOR_ATTRIBUTE = EverrestProcessor.class.getName();
    public static final String PROVIDER_BINDER_ATTRIBUTE = ApplicationProviderBinder.class.getName();
    public static final String MESSAGE_CONVERTER_ATTRIBUTE = MessageConverter.class.getName();
    private EverrestProcessor processor;
    private AsynchronousJobPool asynchronousPool;
    private MessageConverter messageConverter;
    private WebApplicationDeclaredRoles webApplicationRoles;

    public void init() throws ServletException {
        this.processor = this.getEverrestProcessor();
        this.asynchronousPool = this.getAsynchronousJobPool();
        this.messageConverter = this.getMessageConverter();
        if (this.messageConverter == null) {
            this.messageConverter = new JsonMessageConverter();
        }
        this.webApplicationRoles = new WebApplicationDeclaredRoles(this.getServletContext());
    }

    protected StreamInbound createWebSocketInbound(String s, HttpServletRequest req) {
        WSConnectionImpl connection = WSConnectionContext.open(req.getSession(), this.messageConverter);
        connection.registerMessageReceiver(new WS2RESTAdapter(connection, this.createSecurityContext(req), this.processor, this.asynchronousPool));
        return connection;
    }

    protected EverrestProcessor getEverrestProcessor() {
        return (EverrestProcessor)this.getServletContext().getAttribute(EVERREST_PROCESSOR_ATTRIBUTE);
    }

    protected MessageConverter getMessageConverter() {
        return (MessageConverter)this.getServletContext().getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
    }

    protected AsynchronousJobPool getAsynchronousJobPool() {
        ContextResolver asyncJobsResolver;
        ProviderBinder providers = (ProviderBinder)this.getServletContext().getAttribute(PROVIDER_BINDER_ATTRIBUTE);
        if (providers != null && (asyncJobsResolver = providers.getContextResolver(AsynchronousJobPool.class, null)) != null) {
            return (AsynchronousJobPool)asyncJobsResolver.getContext(null);
        }
        throw new IllegalStateException("Unable get web socket connection. Asynchronous jobs feature is not configured properly. ");
    }

    private SecurityContext createSecurityContext(HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            return new SimpleSecurityContext(req.isSecure());
        }
        LinkedHashSet<String> userRoles = new LinkedHashSet<String>();
        for (String declaredRole : this.webApplicationRoles.getDeclaredRoles()) {
            if (!req.isUserInRole(declaredRole)) continue;
            userRoles.add(declaredRole);
        }
        return new SimpleSecurityContext((Principal)new SimplePrincipal(principal.getName()), userRoles, req.getAuthType(), req.isSecure());
    }
}

