/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.EncodeException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.websockets.ServerContainerInitializeListener;
import org.everrest.websockets.WS2RESTAdapter;
import org.everrest.websockets.WSConnection;
import org.everrest.websockets.WSConnectionContext;
import org.everrest.websockets.WSConnectionListener;
import org.everrest.websockets.WSMessageReceiver;
import org.everrest.websockets.message.MessageSender;
import org.everrest.websockets.message.OutputMessage;
import org.everrest.websockets.message.RestInputMessage;

public class WSConnectionImpl
extends Endpoint
implements WSConnection {
    private static final AtomicLong counter = new AtomicLong(1L);
    private final long id = counter.getAndIncrement();
    private final List<WSMessageReceiver> messageReceivers = new CopyOnWriteArrayList<WSMessageReceiver>();
    private final Set<String> channels = new CopyOnWriteArraySet<String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Session wsSession;
    private HttpSession httpSession;
    private CloseReason closeReason;
    private MessageSender messageSender;

    public void onOpen(Session session, EndpointConfig config) {
        this.wsSession = session;
        this.messageSender = new MessageSender(session);
        Map userProperties = config.getUserProperties();
        this.httpSession = (HttpSession)userProperties.get(ServerContainerInitializeListener.HTTP_SESSION_ATTRIBUTE);
        WS2RESTAdapter restAdapter = new WS2RESTAdapter(this, (SecurityContext)userProperties.get(ServerContainerInitializeListener.SECURITY_CONTEXT), (EverrestProcessor)userProperties.get(ServerContainerInitializeListener.EVERREST_PROCESSOR_ATTRIBUTE), (Executor)userProperties.get("everrest.Executor"));
        this.messageReceivers.add(restAdapter);
        this.wsSession.addMessageHandler(RestInputMessage.class, (MessageHandler.Whole)new MessageHandler.Whole<RestInputMessage>(){

            public void onMessage(RestInputMessage message) {
                for (WSMessageReceiver receiver : WSConnectionImpl.this.messageReceivers) {
                    receiver.onMessage(message);
                }
            }
        });
        for (WSConnectionListener connectionListener : WSConnectionContext.connectionListeners) {
            connectionListener.onOpen(this);
        }
        WSConnectionContext.connections.put(this.getId(), this);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.closeReason = closeReason;
        for (WSConnectionListener connectionListener : WSConnectionContext.connectionListeners) {
            connectionListener.onClose(this);
        }
        super.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable thr) {
        if (thr instanceof DecodeException) {
            for (WSMessageReceiver receiver : this.messageReceivers) {
                receiver.onError((Exception)((DecodeException)thr));
            }
        }
        super.onError(session, thr);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Override
    public Session getWsSession() {
        return this.wsSession;
    }

    @Override
    public boolean subscribeToChannel(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name may not be null. ");
        }
        return this.channels.add(channel);
    }

    @Override
    public boolean unsubscribeFromChannel(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel name may not be null. ");
        }
        return this.channels.remove(channel);
    }

    @Override
    public Collection<String> getChannels() {
        return this.channels;
    }

    @Override
    public boolean isConnected() {
        return this.wsSession != null && this.wsSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isConnected()) {
            this.wsSession.close();
        }
    }

    @Override
    public void close(int status, String message) throws IOException {
        if (this.isConnected()) {
            this.wsSession.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)status), message));
        }
    }

    @Override
    public int getCloseStatus() {
        return this.closeReason == null ? 0 : this.closeReason.getCloseCode().getCode();
    }

    @Override
    public void sendMessage(OutputMessage output) throws EncodeException, IOException {
        this.checkIsConnected();
        this.messageSender.send(output);
    }

    private void checkIsConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Unable send message because the WebSocket connection has been closed");
        }
    }

    @Override
    public void registerMessageReceiver(WSMessageReceiver messageReceiver) {
        this.messageReceivers.add(messageReceiver);
    }

    @Override
    public void removeMessageReceiver(WSMessageReceiver messageReceiver) {
        this.messageReceivers.remove(messageReceiver);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("WSConnectionImpl{").append("id=").append(this.id).append(", wsSession=").append(this.wsSession.getId());
        if (this.httpSession != null) {
            sb.append(", httpSession=").append(this.httpSession.getId());
        }
        sb.append(", channels=").append(this.channels).append('}');
        return sb.toString();
    }
}

