/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.websockets.message;

import org.everrest.websockets.message.InputMessage;
import org.everrest.websockets.message.Pair;

public class RestInputMessage
extends InputMessage {
    private String method;
    private String path;
    private Pair[] headers;

    public static RestInputMessage newPingMessage(String uuid, String message) {
        RestInputMessage instance = new RestInputMessage();
        instance.setUuid(uuid);
        instance.setMethod("POST");
        instance.setHeaders(new Pair[]{Pair.of("x-everrest-websocket-message-type", "ping")});
        instance.setBody(message);
        return instance;
    }

    public static RestInputMessage newSubscribeChannelMessage(String uuid, String channel) {
        RestInputMessage instance = new RestInputMessage();
        instance.setUuid(uuid);
        instance.setMethod("POST");
        instance.setHeaders(new Pair[]{Pair.of("x-everrest-websocket-message-type", "subscribe-channel")});
        instance.setBody(String.format("{\"channel\":\"%s\"}", channel));
        return instance;
    }

    public static RestInputMessage newUnsubscribeChannelMessage(String uuid, String channel) {
        RestInputMessage instance = new RestInputMessage();
        instance.setUuid(uuid);
        instance.setMethod("POST");
        instance.setHeaders(new Pair[]{Pair.of("x-everrest-websocket-message-type", "unsubscribe-channel")});
        instance.setBody(String.format("{\"channel\":\"%s\"}", channel));
        return instance;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Pair[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(Pair[] headers) {
        this.headers = headers;
    }
}

