// Generated by delombok at Mon May 03 16:59:54 UTC 2021
package org.exoplatform.analytics.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import lombok.*;

public class StatisticData implements Serializable {
  private static final long serialVersionUID = -2660993500359866340L;
  private static final int PRIME = 59;
  private DateFormat dateFormat;
  private long timestamp;
  private long userId;
  private long spaceId;
  private String module;
  private String subModule;
  private String operation;
  private StatisticStatus status = StatisticStatus.OK;
  private String errorMessage;
  private long duration;
  private long errorCode;
  private Map<String, String> parameters;
  private Map<String, Collection<String>> listParameters;

  public void addParameter(String key, Object value) {
    if (parameters == null) {
      parameters = new HashMap<>();
    }
    if (value == null) {
      return;
    }
    if (value instanceof Collection) {
      Collection<?> collection = (Collection<?>) value;
      Collection<String> values = collection.stream().filter(val -> val != null).map(this::getFieldValue).collect(Collectors.toList());
      if (listParameters == null) {
        listParameters = new HashMap<>();
      }
      listParameters.put(key, values);
    } else {
      parameters.put(key, getFieldValue(value));
    }
  }

  private String getFieldValue(Object value) {
    if (value instanceof Date) {
      return buildDateFormat().format(value);
    } else {
      return String.valueOf(value);
    }
  }

  private DateFormat buildDateFormat() {
    if (dateFormat == null) {
      dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");
    }
    return dateFormat;
  }


  public enum StatisticStatus {
    OK, KO;
  }

  public long computeId() {
    long result = timestamp;
    result = result * PRIME + (int) (userId >>> 32 ^ userId);
    result = result * PRIME + (int) (spaceId >>> 32 ^ spaceId);
    result = result * PRIME + (module == null ? 43 : module.hashCode());
    result = result * PRIME + (subModule == null ? 43 : subModule.hashCode());
    result = result * PRIME + (operation == null ? 43 : operation.hashCode());
    result = result * PRIME + (parameters == null ? 43 : parameters.hashCode());
    return result;
  }

  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof StatisticData)) return false;
    final StatisticData other = (StatisticData) o;
    return hashCode() == other.hashCode();
  }

  public int hashCode() {
    return (int) computeId();
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "StatisticData(timestamp=" + this.getTimestamp() + ", userId=" + this.getUserId() + ", spaceId=" + this.getSpaceId() + ", module=" + this.getModule() + ", subModule=" + this.getSubModule() + ", operation=" + this.getOperation() + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ", duration=" + this.getDuration() + ", errorCode=" + this.getErrorCode() + ", parameters=" + this.getParameters() + ", listParameters=" + this.getListParameters() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public StatisticData(final DateFormat dateFormat, final long timestamp, final long userId, final long spaceId, final String module, final String subModule, final String operation, final StatisticStatus status, final String errorMessage, final long duration, final long errorCode, final Map<String, String> parameters, final Map<String, Collection<String>> listParameters) {
    this.dateFormat = dateFormat;
    this.timestamp = timestamp;
    this.userId = userId;
    this.spaceId = spaceId;
    this.module = module;
    this.subModule = subModule;
    this.operation = operation;
    this.status = status;
    this.errorMessage = errorMessage;
    this.duration = duration;
    this.errorCode = errorCode;
    this.parameters = parameters;
    this.listParameters = listParameters;
  }

  @java.lang.SuppressWarnings("all")
  public StatisticData() {
  }

  @java.lang.SuppressWarnings("all")
  public long getTimestamp() {
    return this.timestamp;
  }

  @java.lang.SuppressWarnings("all")
  public void setTimestamp(final long timestamp) {
    this.timestamp = timestamp;
  }

  @java.lang.SuppressWarnings("all")
  public long getUserId() {
    return this.userId;
  }

  @java.lang.SuppressWarnings("all")
  public void setUserId(final long userId) {
    this.userId = userId;
  }

  @java.lang.SuppressWarnings("all")
  public long getSpaceId() {
    return this.spaceId;
  }

  @java.lang.SuppressWarnings("all")
  public void setSpaceId(final long spaceId) {
    this.spaceId = spaceId;
  }

  @java.lang.SuppressWarnings("all")
  public String getModule() {
    return this.module;
  }

  @java.lang.SuppressWarnings("all")
  public void setModule(final String module) {
    this.module = module;
  }

  @java.lang.SuppressWarnings("all")
  public String getSubModule() {
    return this.subModule;
  }

  @java.lang.SuppressWarnings("all")
  public void setSubModule(final String subModule) {
    this.subModule = subModule;
  }

  @java.lang.SuppressWarnings("all")
  public String getOperation() {
    return this.operation;
  }

  @java.lang.SuppressWarnings("all")
  public void setOperation(final String operation) {
    this.operation = operation;
  }

  @java.lang.SuppressWarnings("all")
  public StatisticStatus getStatus() {
    return this.status;
  }

  @java.lang.SuppressWarnings("all")
  public void setStatus(final StatisticStatus status) {
    this.status = status;
  }

  @java.lang.SuppressWarnings("all")
  public String getErrorMessage() {
    return this.errorMessage;
  }

  @java.lang.SuppressWarnings("all")
  public void setErrorMessage(final String errorMessage) {
    this.errorMessage = errorMessage;
  }

  @java.lang.SuppressWarnings("all")
  public long getDuration() {
    return this.duration;
  }

  @java.lang.SuppressWarnings("all")
  public void setDuration(final long duration) {
    this.duration = duration;
  }

  @java.lang.SuppressWarnings("all")
  public long getErrorCode() {
    return this.errorCode;
  }

  @java.lang.SuppressWarnings("all")
  public void setErrorCode(final long errorCode) {
    this.errorCode = errorCode;
  }

  @java.lang.SuppressWarnings("all")
  public Map<String, String> getParameters() {
    return this.parameters;
  }

  @java.lang.SuppressWarnings("all")
  public void setParameters(final Map<String, String> parameters) {
    this.parameters = parameters;
  }

  @java.lang.SuppressWarnings("all")
  public Map<String, Collection<String>> getListParameters() {
    return this.listParameters;
  }

  @java.lang.SuppressWarnings("all")
  public void setListParameters(final Map<String, Collection<String>> listParameters) {
    this.listParameters = listParameters;
  }
}
