/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.api.websocket;

import org.apache.commons.lang3.StringUtils;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.exoplatform.analytics.api.websocket.AnalyticsWebSocketMessage;
import org.exoplatform.analytics.api.websocket.UserSettings;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class AnalyticsWebSocketService {
    private static final String EXO_ANALYTICS_MESSAGE_EVENT = "exo.analytics.websocket.messageReceived";
    private static final Log LOG = ExoLogger.getLogger(AnalyticsWebSocketService.class);
    public static final String COMETD_CHANNEL = "/service/analytics";
    private ListenerService listenerService;
    private ContinuationService continuationService;
    private EXoContinuationBayeux continuationBayeux;
    private ServerChannel channel;
    private String cometdContextName;

    public void init() {
        if (this.channel == null) {
            this.channel = (ServerChannel)this.getContinuationBayeux().createChannelIfAbsent(COMETD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
            this.channel.addListener((ConfigurableServerChannel.ServerChannelListener)new ServerChannel.MessageListener(){

                public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
                    try {
                        if (message == null || message.getData() == null) {
                            LOG.warn((Object)"Empty analytics WebSocket message is received");
                            return false;
                        }
                        if (from == null) {
                            LOG.warn((Object)"Empty analytics WebSocket session is received");
                            return false;
                        }
                        if (channel == null || !StringUtils.equals((CharSequence)channel.getId(), (CharSequence)AnalyticsWebSocketService.COMETD_CHANNEL)) {
                            LOG.warn((Object)"Empty WebSocket channel received");
                            return false;
                        }
                        if (!StringUtils.equals((CharSequence)channel.getId(), (CharSequence)AnalyticsWebSocketService.COMETD_CHANNEL)) {
                            LOG.debug((Object)"Not Analytics WebSocket channel");
                            return false;
                        }
                        Object data = message.getData();
                        AnalyticsWebSocketMessage wsMessage = AnalyticsUtils.fromJsonString(data.toString(), AnalyticsWebSocketMessage.class);
                        if (StringUtils.isBlank((CharSequence)wsMessage.getUserName())) {
                            LOG.warn((Object)"Empty WebSocket username received");
                            return false;
                        }
                        if (StringUtils.isBlank((CharSequence)wsMessage.getToken())) {
                            LOG.warn((Object)"Empty WebSocket user token received");
                            return false;
                        }
                        String userToken = AnalyticsWebSocketService.this.getUserToken(wsMessage.getUserName());
                        if (!StringUtils.equals((CharSequence)userToken, (CharSequence)wsMessage.getToken())) {
                            LOG.warn("Wrong WebSocket token received for user {}", new Object[]{wsMessage.getUserName()});
                            return false;
                        }
                        AnalyticsWebSocketService.this.getListenerService().broadcast(AnalyticsWebSocketService.EXO_ANALYTICS_MESSAGE_EVENT, (Object)this, (Object)wsMessage);
                        return true;
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Object)"Error when parsing analytics ws message", (Throwable)e);
                        } else {
                            LOG.warn("Error when parsing analytics ws message: {}", new Object[]{e.getMessage()});
                        }
                        return false;
                    }
                }
            });
        }
    }

    public UserSettings getUserSettings(String username) {
        UserSettings userSettings = new UserSettings();
        userSettings.setCometdToken(this.getUserToken(username));
        userSettings.setCometdContext(this.getCometdContextName());
        return userSettings;
    }

    private String getUserToken(String username) {
        try {
            return this.getContinuationService().getUserToken(username);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve continuation token for user " + username), (Throwable)e);
            return "";
        }
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private String getCometdContextName() {
        if (this.cometdContextName == null) {
            this.cometdContextName = this.getContinuationBayeux() == null ? "cometd" : this.getContinuationBayeux().getCometdContextName();
        }
        return this.cometdContextName;
    }

    private EXoContinuationBayeux getContinuationBayeux() {
        if (this.continuationBayeux == null) {
            this.continuationBayeux = (EXoContinuationBayeux)CommonsUtils.getService(EXoContinuationBayeux.class);
        }
        return this.continuationBayeux;
    }

    private ContinuationService getContinuationService() {
        if (this.continuationService == null) {
            this.continuationService = (ContinuationService)CommonsUtils.getService(ContinuationService.class);
        }
        return this.continuationService;
    }
}

