/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;

public class AnalyticsRelationshipListener
extends RelationshipListenerPlugin {
    public void requested(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        StatisticData statisticData = this.buildStatisticData("requested", relationship.getSender().getId(), relationship.getReceiver().getId());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void denied(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        StatisticData statisticData = this.buildStatisticData("denied", relationship.getSender().getId(), relationship.getReceiver().getId());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        StatisticData statisticData = this.buildStatisticData("confirmed", relationship.getSender().getId(), relationship.getReceiver().getId());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void ignored(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        StatisticData statisticData = this.buildStatisticData("ignored", relationship.getSender().getId(), relationship.getReceiver().getId());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public void removed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        StatisticData statisticData = this.buildStatisticData("removed", relationship.getSender().getId(), relationship.getReceiver().getId());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private StatisticData buildStatisticData(String operation, String from, String to) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("relationship");
        statisticData.setOperation(operation);
        long currentUserIdentityId = AnalyticsUtils.getCurrentUserIdentityId();
        statisticData.setUserId(currentUserIdentityId);
        if (currentUserIdentityId > 0L) {
            statisticData.addParameter("modifierSocialId", (Object)currentUserIdentityId);
        }
        statisticData.addParameter("from", (Object)from);
        statisticData.addParameter("to", (Object)to);
        return statisticData;
    }
}

