/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.job;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class SpacesStatisticsCountJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(SpacesStatisticsCountJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private SpaceService spaceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        long startTime = System.currentTimeMillis();
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ListAccess allSpaces = this.getSpaceService().getAllSpacesWithListAccess();
            int allSpacesCount = allSpaces.getSize();
            StatisticData statisticData = new StatisticData();
            statisticData.setModule("social");
            statisticData.setSubModule("space");
            statisticData.setOperation("spacesCount");
            statisticData.setDuration(System.currentTimeMillis() - startTime);
            statisticData.addParameter("countType", (Object)"allSpaces");
            statisticData.addParameter("count", (Object)allSpacesCount);
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while computing spaces statistics", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

