/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.portal;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

@Asynchronous
public class LoginAnalyticsListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(LoginAnalyticsListener.class);
    private static final String LOGIN = "login";

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        ConversationState state = (ConversationState)event.getData();
        long userId = AnalyticsUtils.getUserIdentityId((ConversationState)state);
        if (userId <= 0L) {
            LOG.debug("User not found in state, userId= {} ", new Object[]{userId});
            return;
        }
        boolean isLogin = this.isLogin(event);
        String operation = isLogin ? LOGIN : "logout";
        UserImpl profile = (UserImpl)state.getAttribute("UserProfile");
        Date lastLoginTime = profile.getLastLoginTime();
        if (operation.equals(LOGIN) && DateUtils.isSameDay((Date)new Date(), (Date)lastLoginTime) && !profile.getCreatedDate().equals(lastLoginTime)) {
            return;
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule(LOGIN);
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private boolean isLogin(Event<ConversationRegistry, ConversationState> event) {
        String eventName = event.getEventName();
        return StringUtils.equals((CharSequence)"exo.core.security.ConversationRegistry.register", (CharSequence)eventName);
    }
}

