/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.es;

import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.exoplatform.analytics.es.AnalyticsElasticContentRequestBuilder;
import org.exoplatform.analytics.es.AnalyticsIndexingServiceConnector;
import org.exoplatform.analytics.model.StatisticDataQueueEntry;
import org.exoplatform.commons.search.es.client.ElasticClient;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsESClient
extends ElasticClient {
    private static final Log LOG = ExoLogger.getExoLogger(AnalyticsESClient.class);
    private static final String DEFAULT_ES_CLIENT_SERVER_URL = "http://127.0.0.1:9200";
    private static final String ES_CLIENT_SERVER_URL = "exo.es.index.server.url";
    private static final String ES_CLIENT_USERNAME = "exo.es.index.server.username";
    private static final String ES_CLIENT_PWD = "exo.es.index.server.password";
    private static final String ES_ANALYTICS_CLIENT_SERVER_URL = "exo.es.analytics.index.server.url";
    private static final String ES_ANALYTICS_CLIENT_USERNAME = "exo.es.analytics.index.server.username";
    private static final String ES_ANALYTICS_CLIENT_PWD = "exo.es.analytics.index.server.password";
    private static final String INDEX_TEMPLATE_FILE_PATH_PARAM = "index.template.file.path";
    private static final String ES_ANALYTICS_INDEX_PER_DAYS = "exo.es.analytics.index.per.days";
    private static final long DAY_IN_MS = 86400000L;
    private static final String DAY_DATE_FORMAT = "yyyy-MM-dd";
    public static final DateTimeFormatter DAY_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withResolverStyle(ResolverStyle.LENIENT);
    private AnalyticsIndexingServiceConnector analyticsIndexingConnector;
    private AnalyticsElasticContentRequestBuilder elasticContentRequestBuilder;
    private Set<String> existingIndexes = new HashSet<String>();
    private Map<Long, String> indexSuffixPerDayIndice = new HashMap<Long, String>();
    private int indexPerDays;
    private String esIndexTemplateQuery;
    private String username;
    private String password;

    public AnalyticsESClient(ConfigurationManager configurationManager, AnalyticsElasticContentRequestBuilder elasticContentRequestBuilder, AnalyticsIndexingServiceConnector analyticsIndexingConnector, ElasticIndexingAuditTrail auditTrail, InitParams initParams) {
        super(auditTrail);
        this.analyticsIndexingConnector = analyticsIndexingConnector;
        this.elasticContentRequestBuilder = elasticContentRequestBuilder;
        if (initParams != null) {
            if (initParams.containsKey((Object)ES_ANALYTICS_CLIENT_SERVER_URL)) {
                this.urlClient = initParams.getValueParam(ES_ANALYTICS_CLIENT_SERVER_URL).getValue();
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_CLIENT_USERNAME)) {
                this.username = initParams.getValueParam(ES_ANALYTICS_CLIENT_USERNAME).getValue();
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_CLIENT_PWD)) {
                this.password = initParams.getValueParam(ES_ANALYTICS_CLIENT_PWD).getValue();
            }
            if (initParams.containsKey((Object)INDEX_TEMPLATE_FILE_PATH_PARAM)) {
                String mappingFilePath = initParams.getValueParam(INDEX_TEMPLATE_FILE_PATH_PARAM).getValue();
                try {
                    this.esIndexTemplateQuery = this.getFileContent(configurationManager, mappingFilePath);
                }
                catch (Exception e) {
                    LOG.error("Can't read elasticsearch index mapping from path {}", new Object[]{mappingFilePath, e});
                }
            }
            if (initParams.containsKey((Object)ES_ANALYTICS_INDEX_PER_DAYS)) {
                this.indexPerDays = Integer.parseInt(initParams.getValueParam(ES_ANALYTICS_INDEX_PER_DAYS).getValue());
            }
        }
        if (StringUtils.isBlank((CharSequence)this.urlClient)) {
            this.urlClient = System.getProperty(ES_CLIENT_SERVER_URL);
            this.username = System.getProperty(ES_CLIENT_USERNAME);
            this.password = System.getProperty(ES_CLIENT_PWD);
        }
        if (StringUtils.isBlank((CharSequence)this.urlClient)) {
            this.urlClient = DEFAULT_ES_CLIENT_SERVER_URL;
        }
        if (StringUtils.isBlank((CharSequence)this.esIndexTemplateQuery)) {
            LOG.error((Object)"Empty elasticsearch index mapping file path parameter");
        }
        this.initHttpClient();
    }

    public void init() {
        this.checkIndexTemplateExistence();
        LOG.info((Object)"Analytics client initialized and is ready to proceed analytics data");
    }

    public boolean sendCreateIndexRequest(String index) {
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.debug("Index {} already exists. Index creation requests will not be sent.", new Object[]{index});
            return false;
        }
        this.sendTurnOffWriteOnAllAnalyticsIndexes();
        String esIndexSettings = this.elasticContentRequestBuilder.getCreateIndexRequestContent(this.analyticsIndexingConnector);
        ElasticResponse createIndexResponse = this.sendHttpPutRequest(index, esIndexSettings);
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.info("New analytics index {} created.", new Object[]{index});
            return true;
        }
        throw new IllegalStateException("Error creating index " + index + " on elasticsearch, response code = " + createIndexResponse.getStatusCode() + " , response content : " + createIndexResponse.getMessage());
    }

    public void sendTurnOffWriteOnAllAnalyticsIndexes() {
        if (this.sendIsIndexExistsRequest(this.analyticsIndexingConnector.getIndexAlias())) {
            String esQuery = this.elasticContentRequestBuilder.getTurnOffWriteOnAllAnalyticsIndexes(this.analyticsIndexingConnector);
            try {
                this.sendHttpPostRequest("_aliases", esQuery);
                LOG.info((Object)"All analytics indexes switched to RO mode to prepare creation of a new index");
            }
            catch (ElasticClientException e) {
                LOG.warn((Object)"Analytics old indexes seems to not be turned off on write access");
            }
        }
    }

    public boolean sendIsIndexExistsRequest(String esIndex) {
        boolean indexExists;
        if (this.existingIndexes.contains(esIndex)) {
            return true;
        }
        String url = this.urlClient + "/" + esIndex;
        ElasticResponse responseExists = super.sendHttpGetRequest(url);
        boolean bl = indexExists = responseExists.getStatusCode() == 200;
        if (indexExists) {
            this.existingIndexes.add(esIndex);
        }
        return indexExists;
    }

    public boolean sendIsIndexTemplateExistsRequest() {
        String url = this.urlClient + "/_index_template/" + this.analyticsIndexingConnector.getIndexTemplate();
        ElasticResponse responseExists = super.sendHttpGetRequest(url);
        return responseExists.getStatusCode() == 200;
    }

    public void sendCreateBulkDocumentsRequest(List<StatisticDataQueueEntry> dataQueueEntries) {
        if (dataQueueEntries == null || dataQueueEntries.isEmpty()) {
            return;
        }
        LOG.info("Indexing in bulk {} documents", new Object[]{dataQueueEntries.size()});
        this.checkIndexExistence(dataQueueEntries);
        StringBuilder request = new StringBuilder();
        for (StatisticDataQueueEntry statisticDataQueueEntry : dataQueueEntries) {
            String documentId = String.valueOf(statisticDataQueueEntry.getId());
            String singleDocumentQuery = this.elasticContentRequestBuilder.getCreateDocumentRequestContent(this.analyticsIndexingConnector, documentId);
            request.append(singleDocumentQuery);
        }
        LOG.debug("Create documents request to ES: {}", new Object[]{request});
        this.sendHttpPutRequest("_bulk", request.toString());
        this.refreshIndex();
    }

    public String sendRequest(String esQuery) {
        ElasticResponse elasticResponse = this.sendHttpPostRequest(this.analyticsIndexingConnector.getIndexAlias() + "/_search", esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (ElasticIndexingAuditTrail.isError((Integer)statusCode) || StringUtils.isBlank((CharSequence)response)) {
            if (StringUtils.isBlank((CharSequence)response)) {
                response = "Empty response was sent by ES";
            }
        } else {
            JSONObject json = null;
            try {
                json = new JSONObject(response);
                if (json.has("status") && ElasticIndexingAuditTrail.isError((Integer)json.getInt("status"))) {
                    throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
                }
            }
            catch (JSONException e) {
                throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
            }
        }
        return response;
    }

    public String retrieveAllAnalyticsIndexesMapping() {
        String url = this.urlClient + "/" + this.analyticsIndexingConnector.getIndexAlias() + "/_mapping";
        ElasticResponse response = super.sendHttpGetRequest(url);
        if (ElasticIndexingAuditTrail.isError((Integer)response.getStatusCode())) {
            LOG.warn("Error getting mapping of analytics : - \t\tcode : {} - \t\tmessage: {}", new Object[]{response.getStatusCode(), response.getMessage()});
            return null;
        }
        return response.getMessage();
    }

    protected ElasticResponse sendHttpHeadRequest(String uri) {
        String url = this.urlClient + "/" + uri;
        ElasticResponse response = super.sendHttpHeadRequest(url);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending HEAD request '" + uri + "'", (Throwable)e);
        }
        return response;
    }

    public ElasticResponse sendHttpGetRequest(String uri) {
        return this.sendHttpGetRequest(null, uri);
    }

    public ElasticResponse sendHttpGetRequest(String urlClient, String uri) {
        if (StringUtils.isBlank((CharSequence)urlClient)) {
            urlClient = this.urlClient;
        }
        String url = urlClient + "/" + uri;
        ElasticResponse response = super.sendHttpGetRequest(url);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending GET request '" + url + "'", (Throwable)e);
        }
        return response;
    }

    public ElasticResponse sendHttpPutRequest(String uri, String content) {
        String url = this.urlClient + "/" + uri;
        ElasticResponse response = super.sendHttpPutRequest(url, content);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending PUT request '" + url + "' with content = '" + content + "'", (Throwable)e);
        }
        return response;
    }

    public ElasticResponse sendHttpDeleteRequest(String uri) {
        String url = this.urlClient + "/" + uri;
        ElasticResponse response = super.sendHttpDeleteRequest(url);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending 'DELETE' request '" + url + "'", (Throwable)e);
        }
        return response;
    }

    public ElasticResponse sendHttpPostRequest(String uri, String content) {
        String url = this.urlClient + "/" + uri;
        ElasticResponse response = super.sendHttpPostRequest(url, content);
        try {
            this.handleESResponse(response);
        }
        catch (Exception e) {
            throw new ElasticClientException("Error sending POST request '" + url + "' with content = '" + content + "'", (Throwable)e);
        }
        return response;
    }

    public String getIndexSuffix(long timestamp) {
        long indexSuffixLong = timestamp / (86400000L * (long)this.indexPerDays);
        String indexSuffix = this.indexSuffixPerDayIndice.get(indexSuffixLong);
        if (indexSuffix != null) {
            return indexSuffix;
        }
        indexSuffix = DAY_DATE_FORMATTER.format(Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.UTC));
        this.indexSuffixPerDayIndice.put(indexSuffixLong, indexSuffix);
        return indexSuffix;
    }

    public void refreshIndex() {
        this.refreshIndex(this.analyticsIndexingConnector.getIndexAlias());
    }

    public void refreshIndex(String index) {
        this.sendHttpPostRequest(index + "/_refresh", null);
    }

    public int getIndexPerDays() {
        return this.indexPerDays;
    }

    protected String getEsUsernameProperty() {
        return this.username;
    }

    protected String getEsPasswordProperty() {
        return this.password;
    }

    protected HttpClientConnectionManager getClientConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    private void handleESResponse(ElasticResponse response) {
        if (response.getStatusCode() != 200) {
            throw new ElasticClientException(response.getMessage());
        }
        if (StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\"type\":\"version_conflict_engine_exception\"")) {
            LOG.warn("ID conflict in some content", new Object[]{response.getMessage()});
            return;
        }
        if (response.getStatusCode() != 200 || StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\"errors\":true")) {
            throw new ElasticClientException(response.getMessage());
        }
    }

    private void checkIndexExistence(List<StatisticDataQueueEntry> dataQueueEntries) {
        HashSet<String> indexes = new HashSet<String>();
        for (StatisticDataQueueEntry statisticDataQueueEntry : dataQueueEntries) {
            long timestamp = statisticDataQueueEntry.getStatisticData().getTimestamp();
            indexes.add(this.getIndex(timestamp));
        }
        for (String index : indexes) {
            this.sendCreateIndexRequest(index);
        }
    }

    private void checkIndexTemplateExistence() {
        String indexTemplate = this.analyticsIndexingConnector.getIndexTemplate();
        if (this.sendIsIndexTemplateExistsRequest()) {
            LOG.debug("Index Template {} already exists. Index creation requests will not be sent.", new Object[]{indexTemplate});
        } else {
            long startTime = System.currentTimeMillis();
            this.esIndexTemplateQuery = this.esIndexTemplateQuery.replace("analytics_template", this.analyticsIndexingConnector.getIndexAlias()).replace("replica.number", String.valueOf(this.analyticsIndexingConnector.getReplicas())).replace("shard.number", String.valueOf(this.analyticsIndexingConnector.getShards()));
            ElasticResponse responseCreate = this.sendHttpPostRequest("_index_template/" + indexTemplate, this.esIndexTemplateQuery);
            this.auditTrail.audit("create_index_template", null, indexTemplate, Integer.valueOf(responseCreate.getStatusCode()), responseCreate.getMessage(), System.currentTimeMillis() - startTime);
            if (this.sendIsIndexTemplateExistsRequest()) {
                LOG.info("Index Template {} created.", new Object[]{indexTemplate});
                this.analyticsIndexingConnector.storeCreatedIndexTemplate();
            } else {
                throw new IllegalStateException("Index Template " + indexTemplate + " isn't created successfully");
            }
        }
    }

    private final String getIndex(long timestamp) {
        if (this.indexPerDays > 0) {
            String indexSuffix = this.getIndexSuffix(timestamp);
            return this.analyticsIndexingConnector.getIndexPrefix() + "_" + indexSuffix;
        }
        return null;
    }

    private String getFileContent(ConfigurationManager configurationManager, String filePath) throws Exception {
        InputStream mappingFileIS = configurationManager.getInputStream(filePath);
        return IOUtil.getStreamContentAsString((InputStream)mappingFileIS);
    }
}

