/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.analytics.portlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.exoplatform.addon.analytics.portlet.AbstractAnalyticsPortlet;
import org.exoplatform.analytics.model.chart.ChartDataList;
import org.exoplatform.analytics.model.filter.AbstractAnalyticsFilter;
import org.exoplatform.analytics.model.filter.AnalyticsFilter;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class AnalyticsPortlet
extends AbstractAnalyticsPortlet<AnalyticsFilter> {
    protected String getViewPagePath() {
        return "/WEB-INF/jsp/analytics.jsp";
    }

    protected Class<AnalyticsFilter> getFilterClass() {
        return AnalyticsFilter.class;
    }

    protected void readSettings(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)filter));
    }

    protected void readSettingsReadOnly(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        JSONObject jsonResponse = new JSONObject();
        this.addJSONParam(jsonResponse, "title", (Object)filter.getTitle());
        this.addJSONParam(jsonResponse, "chartType", (Object)filter.getChartType());
        List colors = filter.getColors() == null ? Collections.emptyList() : filter.getColors();
        this.addJSONParam(jsonResponse, "colors", (Object)new JSONArray((Collection)colors));
        this.addJSONParam(jsonResponse, "canEdit", (Object)this.canModifySettings((PortletRequest)request));
        this.addJSONParam(jsonResponse, "scope", (Object)this.getSearchScope((PortletRequest)request).name());
        response.setContentType("application/json");
        response.getWriter().write(jsonResponse.toString());
    }

    protected void readSamples(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        this.addPeriodFilter(request, filter);
        this.addScopeFilter(request, filter);
        this.addLanguageFilter(request, filter);
        this.addLimitFilter(request, filter);
        this.addTimeZoneFilter(request, (AbstractAnalyticsFilter)filter);
        this.addSortFilter(filter, "desc");
        List statisticDatas = this.getAnalyticsService().retrieveData(filter);
        List objectMappings = statisticDatas.stream().map(statisticData -> {
            JSONObject object = new JSONObject(statisticData);
            object.remove("class");
            return object;
        }).collect(Collectors.toList());
        JSONArray jsonArrayResponse = new JSONArray(objectMappings);
        response.setContentType("application/json");
        response.getWriter().write(jsonArrayResponse.toString());
    }

    protected void readData(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        this.addPeriodFilter(request, filter);
        this.addScopeFilter(request, filter);
        this.addLanguageFilter(request, filter);
        this.addTimeZoneFilter(request, (AbstractAnalyticsFilter)filter);
        ChartDataList result = this.getAnalyticsService().computeChartData(filter);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)result));
    }
}

