/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.faq;

import java.util.Arrays;
import java.util.HashMap;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.forum.extras.injection.faq.AbstractFAQInjector;

public class MembershipInjector
extends AbstractFAQInjector {
    private static final String TYPE = "type";
    private static final String TO_TYPE = "toType";
    private static final String TYPE_PREFIX = "typePrefix";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private int toType;
    private String typePrefix;
    private int fromUser;
    private int toUser;
    private String userPrefix;

    public void inject(HashMap<String, String> params) throws Exception {
        String type = params.get(TYPE);
        if (type == null | type.length() <= 0) {
            this.getLog().info((Object)"Type value is wrong! Please set it exactly with 'category', 'question', or 'answer' value. Aborting injection ...");
            return;
        }
        this.toType = this.param(params, TO_TYPE);
        this.typePrefix = params.get(TYPE_PREFIX);
        this.fromUser = this.param(params, FROM_USER);
        this.toUser = this.param(params, TO_USER);
        this.userPrefix = params.get(USER_PREFIX);
        if ("category".equals(type)) {
            this.init(this.userPrefix, this.typePrefix, null, null, null, 0);
            this.injectCategory();
        } else if ("question".equals(type)) {
            this.init(this.userPrefix, null, this.typePrefix, null, null, 0);
            this.injectQuestion();
        } else if ("answer".equals(type)) {
            this.init(this.userPrefix, null, null, this.typePrefix, null, 0);
            this.injectAnswer();
        }
    }

    private void injectCategory() throws Exception {
        String categoryName = this.categoryBase + this.toType;
        Category cat = this.getCategoryByName(categoryName);
        if (cat == null) {
            this.getLog().info((Object)("category name '" + categoryName + "' is wrong. Aborting injection ..."));
            return;
        }
        Object[] userNames = this.getUserNames();
        if (userNames == null | userNames.length <= 0) {
            this.getLog().info((Object)("Don't assign permission any user to '" + categoryName + "' category. Aborting injection ..."));
            return;
        }
        cat = this.faqService.getCategoryById(cat.getPath().substring(cat.getPath().lastIndexOf("/") + 1));
        cat.setModerators((String[])userNames);
        cat.setUserPrivate((String[])userNames);
        this.faqService.saveCategory(this.getCategoryRoot(true).getPath(), cat, false);
        this.getLog().info((Object)("Assign permission '" + Arrays.toString(userNames) + "' user(s) into '" + categoryName + "' category."));
    }

    private void injectQuestion() throws Exception {
        String questionName = this.questionBase + this.toType;
        Question question = this.getQuestionByName(questionName);
        if (question == null) {
            this.getLog().info((Object)("question name is '" + questionName + "' is wrong. Aborting injection ..."));
            return;
        }
        Object[] userNames = this.getUserNames();
        if (userNames == null | userNames.length <= 0) {
            this.getLog().info((Object)("Don't assign permission any user to '" + questionName + "' question. Aborting injection ..."));
            return;
        }
        question = this.faqService.getQuestionById(question.getPath());
        question.setUsersVote((String[])userNames);
        this.faqService.saveQuestion(question, false, this.faqSetting);
        this.getLog().info((Object)("Assign permission '" + Arrays.toString(userNames) + "' user(s) into '" + questionName + "' question in '" + question.getCategoryId() + "' category."));
    }

    private void injectAnswer() throws Exception {
        String aswerName = this.answerBase + this.toType;
        Answer answer = this.getAnswerByName(aswerName);
        if (answer == null) {
            this.getLog().info((Object)("answer name is '" + aswerName + "' is wrong. Aborting injection ..."));
            return;
        }
        Object[] userNames = this.getUserNames();
        if (userNames == null | userNames.length <= 0) {
            this.getLog().info((Object)("Don't assign permission any user to '" + aswerName + "' answer. Aborting injection ..."));
            return;
        }
        String questionId = answer.getPath().substring(answer.getPath().indexOf("categories"), answer.getPath().indexOf(Utils.ANSWER_HOME) - 1);
        answer = this.faqService.getAnswerById(questionId, answer.getId());
        answer.setUsersVoteAnswer((String[])userNames);
        if (answer.getLanguage() == null) {
            answer.setNew(true);
            answer.setLanguage("English");
        }
        this.faqService.saveAnswer(questionId, answer, true);
        this.getLog().info((Object)("Assign permission '" + Arrays.toString(userNames) + "' user(s) into '" + aswerName + "' answer in '" + questionId + "' question."));
    }

    private String[] getUserNames() throws Exception {
        String[] result = new String[this.toUser - this.fromUser + 1];
        int userIdx = 0;
        for (int i = this.fromUser; i <= this.toUser; ++i) {
            String username = this.userBase + i;
            if (this.userHandler.findUserByName(username) == null) continue;
            result[userIdx] = username;
            ++userIdx;
        }
        return result;
    }
}

