/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.ext.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.answer.ext.impl.ActivityUtils;
import org.exoplatform.answer.ext.impl.BaseKSActivity;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.DataStorage;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/forum/social-integration/plugin/space/AnswerUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={PostCommentActionListener.class})})
public class AnswerUIActivity
extends BaseKSActivity {
    private Question question = null;
    private static final Log LOG = ExoLogger.getExoLogger(AnswerUIActivity.class);
    private static final String ANSWER_PAGE_NAGVIGATION = "answers";
    private static final String ANSWER_SPACE_NAGVIGATION = "answer";
    private static final String ANSWER_PORTLET_NAME = "AnswersPortlet";

    private Question getQuestion() {
        DataStorage faqService = (DataStorage)CommonsUtils.getService(DataStorage.class);
        try {
            return faqService.getQuestionById(this.getQuestionId());
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to get question object", (Throwable)e);
            return null;
        }
    }

    protected String getViewCommentLink(ExoSocialActivity comment) {
        String itemId = (String)comment.getTemplateParams().get("Link");
        if (itemId == null || itemId.indexOf(Comment.COMMENT_ID) != 0) {
            itemId = "";
        }
        return new StringBuffer(this.getLink()).append("#").append(itemId).toString();
    }

    private String getNodeURL(UserNode node) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        return nodeURL.setNode(node).toString();
    }

    private String getAnswerPortletInSpace(String spaceGroupId) {
        NavigationContext nav;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(SiteKey.group((String)spaceGroupId)), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            NodeContext nodeCtx = (NodeContext)parentNodeCtx.get(0);
            Collection children = nodeCtx.getNodes();
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!ANSWER_SPACE_NAGVIGATION.equals(child.getName()) && child.getName().indexOf(ANSWER_PORTLET_NAME) < 0) continue;
                return child.getName();
            }
        }
        return "";
    }

    public String getSpaceHomeURL(String spaceGroupId) {
        if ("".equals(spaceGroupId)) {
            return null;
        }
        String permanentSpaceName = spaceGroupId.split("/")[2];
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(spaceGroupId);
        if (space == null) {
            return null;
        }
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, space.getPrettyName());
        return nodeURL.setResource(resource).toString();
    }

    private String getLink() {
        String[] questionPath = this.getQuestionId().split("/");
        String questionId = questionPath[questionPath.length - 1];
        String spaceLink = this.getSpaceHomeURL(this.getSpaceGroupId());
        if (spaceLink == null) {
            UserNavigation userNav;
            PortalRequestContext prc = Util.getPortalRequestContext();
            UserPortal userPortal = prc.getUserPortal();
            UserNode userNode = userPortal.getNode(userNav = userPortal.getNavigation(prc.getSiteKey()), Scope.ALL, null, null);
            UserNode answerNode = userNode.getChild(ANSWER_PAGE_NAGVIGATION);
            if (answerNode != null) {
                String answerURI = this.getNodeURL(answerNode);
                return String.format("%s%s%s", answerURI, org.exoplatform.faq.service.Utils.QUESTION_ID, questionId);
            }
            return "";
        }
        if (this.getAnswerPortletInSpace(this.getSpaceGroupId()).length() == 0) {
            return "";
        }
        return String.format("%s/%s%s%s", spaceLink, this.getAnswerPortletInSpace(this.getSpaceGroupId()), org.exoplatform.faq.service.Utils.QUESTION_ID, questionId);
    }

    private String getAnswerLink() {
        String spaceLink = this.getSpaceHomeURL(this.getSpaceGroupId());
        if (spaceLink == null) {
            return this.getActivityParamValue("Link").concat(org.exoplatform.faq.service.Utils.ANSWER_NOW.concat("true"));
        }
        String[] tab = this.getQuestionId().split("/");
        String answerLink = String.format("%s/answer%s%s", spaceLink, org.exoplatform.faq.service.Utils.QUESTION_ID.concat(tab[tab.length - 1]), org.exoplatform.faq.service.Utils.ANSWER_NOW.concat("true"));
        return answerLink;
    }

    private String getNumberOfAnswers() throws Exception {
        String number_str = this.getActivityParamValue("NumberOfAnswers");
        int number = Integer.parseInt(CommonUtils.isEmpty((String)number_str) ? ActivityUtils.getNbOfAnswers(this.getQuestion()) : number_str);
        if (number == 0) {
            return WebUIUtils.getLabel(null, (String)"AnswerUIActivity.label.noAnswer");
        }
        if (number == 1) {
            return WebUIUtils.getLabel(null, (String)"AnswerUIActivity.label.answer").replace("{0}", String.valueOf(number));
        }
        return WebUIUtils.getLabel(null, (String)"AnswerUIActivity.label.answers").replace("{0}", String.valueOf(number));
    }

    private double getRating() {
        String rate = this.getActivityParamValue("QuestionRating");
        if (CommonUtils.isEmpty((String)rate)) {
            rate = ActivityUtils.getQuestionRate(this.getQuestion());
        }
        try {
            return Double.parseDouble(rate);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private String getNumberOfComments() throws Exception {
        String number_str = this.getActivityParamValue("NumberOfComments");
        int number = Integer.parseInt(CommonUtils.isEmpty((String)number_str) ? ActivityUtils.getNbOfComments(this.getQuestion()) : number_str);
        if (number == 0) {
            return WebUIUtils.getLabel(null, (String)"AnswerUIActivity.label.noComment");
        }
        if (number == 1) {
            return WebUIUtils.getLabel(null, (String)"AnswerUIActivity.label.comment").replace("{0}", String.valueOf(number));
        }
        return WebUIUtils.getLabel(null, (String)"AnswerUIActivity.label.comments").replace("{0}", String.valueOf(number));
    }

    protected String getQuestionTitle() {
        try {
            return this.getQuestion().getQuestion();
        }
        catch (Exception e) {
            return this.getActivity().getTitle();
        }
    }

    protected String getQuestionDetail() {
        try {
            return ActivityUtils.processContent(this.getQuestion().getDetail());
        }
        catch (Exception e) {
            return this.getActivity().getBody();
        }
    }

    private String getSpaceGroupId() {
        return ActivityUtils.getSpaceGroupId(this.getQuestion().getCategoryId());
    }

    private String getQuestionId() {
        String questionId = this.getActivityParamValue("Id");
        return CommonUtils.isEmpty((String)questionId) ? this.getActivityParamValue("QuestionId") : questionId;
    }

    private ExoSocialActivity toActivity(Comment comment) {
        ExoSocialActivityImpl activity = null;
        if (comment != null) {
            activity = new ExoSocialActivityImpl();
            IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", comment.getCommentBy(), false);
            activity.setUserId(userIdentity.getId());
            activity.setTitle(comment.getComments());
            activity.setPostedTime(Long.valueOf(comment.getDateComment().getTime()));
            activity.setId(comment.getId());
        }
        return activity;
    }

    public static String getFullName(String userName) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            User user = organizationService.getUserHandler().findUserByName(userName);
            String fullName = user.getDisplayName();
            if (fullName == null || fullName.trim().length() <= 0) {
                fullName = new StringBuffer(user.getFirstName()).append(" ").append(user.getLastName()).toString();
            }
            return fullName;
        }
        catch (Exception e) {
            return userName;
        }
    }

    public int getQuestionPoint() {
        try {
            String sQuestionPoint = this.getActivityParamValue("QuestionPoint");
            if (CommonUtils.isEmpty((String)sQuestionPoint)) {
                DataStorage faqService = (DataStorage)CommonsUtils.getService(DataStorage.class);
                int questionPoint = org.exoplatform.faq.service.Utils.getQuestionPoint((Question)this.getQuestion());
                ActivityManager activityM = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
                ExoSocialActivity activity = activityM.getActivity(faqService.getActivityIdForQuestion(this.question.getPath()));
                Map templateParams = activity.getTemplateParams();
                templateParams.put("QuestionPoint", String.valueOf(questionPoint));
                activityM.updateActivity(activity);
                return questionPoint;
            }
            return Integer.parseInt(sQuestionPoint);
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)this.getApplicationComponent(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            Locale userLocale = requestContext.getLocale();
            activity = i18NActivityProcessor.processKeys(activity, userLocale);
        }
        if (!CommonUtils.isEmpty((String)activity.getTitle())) {
            String title = activity.getTitle().replaceAll("&amp;", "&");
            if (title.indexOf("<script") >= 0) {
                title = title.replace("<script", "&lt;script").replace("</script>", "&lt;/script&gt;");
            }
            activity.setTitle(title);
        }
        if (!CommonUtils.isEmpty((String)activity.getBody()) && !activity.isComment()) {
            activity.setBody(activity.getBody().replaceAll("&amp;", "&"));
        }
        return activity;
    }

    public static class PostCommentActionListener
    extends BaseUIActivity.PostCommentActionListener {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            ForumService forumService;
            Topic topic;
            AnswerUIActivity uiActivity = (AnswerUIActivity)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            if (message == null || message.trim().length() == 0) {
                context.getUIApplication().addMessage(new ApplicationMessage("AnswerUIActivity.msg.content-empty", null, 1));
                return;
            }
            message = message.replace("<p>", "").replace("</p>", "\n");
            String enCodeMessage = TransformHTML.enCodeHTMLContent((String)message);
            DataStorage faqService = (DataStorage)CommonsUtils.getService(DataStorage.class);
            Question question = faqService.getQuestionById(uiActivity.getQuestionId());
            Comment comment = new Comment();
            comment.setNew(true);
            comment.setCommentBy(context.getRemoteUser());
            comment.setComments(message);
            comment.setFullName(AnswerUIActivity.getFullName(context.getRemoteUser()));
            comment.setDateComment(new Date());
            String topicId = question.getTopicIdDiscuss();
            if (topicId != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)CommonsUtils.getService(ForumService.class)).getObjectNameById(topicId, Utils.TOPIC)) != null) {
                String remoteAddr = WebUIUtils.getRemoteIP();
                String[] ids = topic.getPath().split("/");
                int t = ids.length;
                String postId = comment.getPostId();
                if (postId == null || postId.length() == 0) {
                    Post post = new Post();
                    post.setOwner(context.getRemoteUser());
                    post.setIcon("ViewIcon");
                    post.setName("Re: " + question.getQuestion());
                    post.setMessage(enCodeMessage);
                    post.setLink(postId);
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setRemoteAddr(remoteAddr);
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, new MessageBuilder());
                    comment.setPostId(post.getId());
                } else {
                    Post post = forumService.getPost(ids[t - 3], ids[t - 2], topicId, postId);
                    boolean isNew = false;
                    if (post == null) {
                        post = new Post();
                        isNew = true;
                        post.setOwner(context.getRemoteUser());
                        post.setIcon("ViewIcon");
                        post.setName("Re: " + question.getQuestion());
                        comment.setPostId(post.getId());
                        post.setLink(postId);
                        post.setRemoteAddr(remoteAddr);
                    } else {
                        post.setModifiedBy(context.getRemoteUser());
                    }
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setMessage(enCodeMessage);
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, isNew, new MessageBuilder());
                }
            }
            ExoSocialActivity cm = uiActivity.toActivity(comment);
            ActivityManager activityM = (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
            ExoSocialActivity activity = activityM.getActivity(faqService.getActivityIdForQuestion(question.getPath()));
            if (activity == null || !uiActivity.getActivity().getId().equals(activity.getId())) {
                activity = uiActivity.getActivity();
                activityM.saveComment(activity, cm);
                uiActivity.refresh();
                context.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
                uiActivity.getParent().broadcast(event, event.getExecutionPhase());
                return;
            }
            comment.setComments(enCodeMessage);
            faqService.saveComment(question.getPath(), comment, true);
            Map templateParams = activity.getTemplateParams();
            question = uiActivity.getQuestion();
            templateParams.put("NumberOfComments", String.valueOf(question.getComments().length));
            activity.setTemplateParams(templateParams);
            activity.setBody(null);
            activity.setTitle(null);
            activityM.updateActivity(activity);
            HashMap<String, String> commentTemplateParams = new HashMap<String, String>();
            commentTemplateParams.put("Link", comment.getId());
            cm.setTemplateParams(commentTemplateParams);
            activityM.saveComment(activity, cm);
            faqService.saveActivityIdForComment(question.getPath(), comment.getId(), question.getLanguage(), cm.getId());
            uiActivity.refresh();
            context.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

