/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.notification.plugin;

import org.exoplatform.answer.ext.activity.ForumActivityUtils;
import org.exoplatform.answer.notification.plugin.ForumNotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class AnswerActivityChildPlugin
extends AbstractNotificationChildPlugin {
    public static final String ID = "ks-answer:spaces";
    private ExoSocialActivity activity = null;

    public AnswerActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        try {
            String activityUrl;
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = new TemplateContext(ID, language);
            String activityId = notification.getValueOwnerParameter(ForumNotificationUtils.ACTIVITY_ID.getKey());
            ActivityManager activityManager = ForumActivityUtils.getActivityManager();
            this.activity = activityManager.getActivity(activityId);
            if (this.activity.isComment()) {
                this.activity = activityManager.getParentActivity(this.activity);
                activityUrl = CommonsUtils.getCurrentDomain() + (String)this.activity.getTemplateParams().get("Link");
            } else {
                activityUrl = (String)this.activity.getTemplateParams().get("Link");
            }
            templateContext.put((Object)"ACTIVITY", (Object)this.activity.getTitle());
            templateContext.put((Object)"ACTIVITY_URL", (Object)activityUrl);
            String content = TemplateUtils.processGroovy((TemplateContext)templateContext);
            return content;
        }
        catch (Exception e) {
            return this.activity != null ? this.activity.getTitle() : "";
        }
    }

    public String getActivityParamValue(String key) {
        return ForumNotificationUtils.getActivityParamValue(this.activity, key);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }
}

