/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.exoplatform.answer.rendering.RenderHelper;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.UIResponseForm;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormRichtextInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/popup/UIResponseForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddRelationActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveRelationActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeLanguageActionListener.class}, phase=Event.Phase.DECODE)})
public class UIResponseForm
extends BaseUIFAQForm
implements UIPopupComponent {
    private static final String QUESTION_LANGUAGE = "Language";
    private static final String RESPONSE_CONTENT = "QuestionRespone";
    private static final String SHOW_ANSWER = "QuestionShowAnswer";
    private static final String IS_APPROVED = "QuestionApproved";
    private Question question_ = null;
    private String questionDetail = "";
    private String questionContent = "";
    private boolean isModerator = true;
    private UIFormSelectBox questionLanguages_;
    private UIFormRichtextInput inputResponseQuestion_;
    private UICheckBoxInput checkShowAnswer_;
    private UICheckBoxInput isApproved_;
    public String questionId_ = "";
    private List<String> listRelationQuestion = new ArrayList();
    private List<String> listQuestIdRela = new ArrayList();
    Map<String, Answer> mapAnswers = new HashMap();
    Map<String, QuestionLanguage> languageMap = new HashMap();
    private Set<String> listLanguageToReponse = new HashSet();
    private String currentLanguage = "";
    private boolean isChildOfQuestionManager_ = false;
    private FAQSetting faqSetting_;
    private boolean isAnswerApproved = true;
    private RenderHelper renderHelper = new RenderHelper();
    private Locale currentLocale = null;

    public UIResponseForm() throws Exception {
        this.inputResponseQuestion_ = new UIFormRichtextInput(RESPONSE_CONTENT, RESPONSE_CONTENT, "");
        this.inputResponseQuestion_.setIgnoreParserHTML(true).setIsPasteAsPlainText(true).setToolbar("FAQ");
        this.inputResponseQuestion_.addValidator(MandatoryValidator.class, new Object[0]);
        this.checkShowAnswer_ = new UICheckBoxInput(SHOW_ANSWER, SHOW_ANSWER, Boolean.valueOf(false));
        this.isApproved_ = new UICheckBoxInput(IS_APPROVED, IS_APPROVED, Boolean.valueOf(false));
        this.questionLanguages_ = new UIFormSelectBox(QUESTION_LANGUAGE, QUESTION_LANGUAGE, null);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setModertator(boolean isMod) {
        this.isModerator = isMod;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public Question getQuestion() {
        return this.question_;
    }

    private void setValueTextInput(String value) {
        if (CommonUtils.isEmpty((String)value)) {
            value = "";
        }
        this.inputResponseQuestion_.setValue((Object)CommonUtils.decodeSpecialCharToHTMLnumberIgnore((String)value));
    }

    public void setAnswerInfor(Question question, Answer answer, String language) {
        this.setQuestionId(question, language, answer.getApprovedAnswers());
        this.mapAnswers.clear();
        this.mapAnswers.put(answer.getLanguage(), answer);
        this.setValueTextInput(answer.getResponses());
        this.questionLanguages_.setValue(answer.getLanguage());
        this.questionLanguages_.setSelectedValues(new String[]{answer.getLanguage()});
        this.getUICheckBoxInput(SHOW_ANSWER).setChecked(answer.getActivateAnswers());
        this.getUICheckBoxInput(IS_APPROVED).setChecked(answer.getApprovedAnswers());
    }

    public void setLanguages() throws Exception {
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        if (this.currentLocale == null || !this.currentLocale.getLanguage().equals(currentLocale.getLanguage())) {
            this.currentLocale = currentLocale;
            this.displayLanguages();
        }
    }

    private void displayLanguages() {
        Map mapLangauge = FAQUtils.getQuestionLanguages((Set)this.listLanguageToReponse);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String lang : this.listLanguageToReponse) {
            String displayName;
            String string = displayName = mapLangauge.containsKey(lang) ? (String)mapLangauge.get(lang) : lang;
            if (lang.equals(this.question_.getLanguage())) {
                displayName = displayName + " (" + WebUIUtils.getLabel(null, (String)"UIQuestionForm.label.default") + ") ";
            }
            options.add(new SelectItemOption(displayName, (Object)lang));
        }
        this.questionLanguages_.setOptions(options);
    }

    public void setQuestionId(Question question, String languageViewed, boolean isAnswerApp) {
        this.isAnswerApproved = isAnswerApp;
        try {
            this.questionDetail = question.getDetail();
            this.questionContent = question.getQuestion();
            this.listRelationQuestion.clear();
            this.listQuestIdRela.clear();
            this.question_ = question;
            this.currentLanguage = languageViewed != null && languageViewed.trim().length() > 0 ? languageViewed : question.getLanguage();
            this.setListRelation();
        }
        catch (Exception e) {
            this.log.error((Object)("Can not set Question id, exception: " + e.getMessage()));
        }
        this.questionId_ = question.getPath();
        this.listLanguageToReponse.clear();
        this.listLanguageToReponse.add(this.question_.getLanguage());
        QuestionLanguage defaultLanguage = new QuestionLanguage();
        defaultLanguage.setLanguage(question.getLanguage());
        defaultLanguage.setQuestion(question.getQuestion());
        defaultLanguage.setDetail(question.getDetail());
        defaultLanguage.setState(QuestionLanguage.VIEW);
        this.languageMap.put(defaultLanguage.getLanguage(), defaultLanguage);
        try {
            for (QuestionLanguage language : this.getFAQService().getQuestionLanguages(this.questionId_)) {
                if (language.getLanguage().equals(this.currentLanguage)) {
                    this.questionDetail = language.getDetail();
                    this.questionContent = language.getQuestion();
                }
                this.languageMap.put(language.getLanguage(), language);
                this.listLanguageToReponse.add(language.getLanguage());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Can not set Question id, exception: " + e.getMessage()));
        }
        this.checkShowAnswer_.setChecked(this.question_.isActivated());
        this.checkShowAnswer_.setRendered(this.isModerator);
        this.isApproved_.setChecked(this.isAnswerApproved);
        this.isApproved_.setRendered(this.isModerator);
        this.displayLanguages();
        this.questionLanguages_.setValue(this.currentLanguage);
        this.questionLanguages_.setSelectedValues(new String[]{this.currentLanguage});
        this.questionLanguages_.setOnChange("ChangeLanguage");
        this.questionLanguages_.setRendered(this.listLanguageToReponse.size() > 1);
        this.addChild((UIComponent)this.inputResponseQuestion_);
        this.addChild((UIComponent)this.questionLanguages_);
        this.addChild((UIComponent)this.isApproved_);
        this.addChild((UIComponent)this.checkShowAnswer_);
    }

    protected String render(String s) {
        Question question = new Question();
        question.setDetail(s);
        return this.renderHelper.renderQuestion(question);
    }

    protected String getValue(String id) {
        if (id.equals("QuestionTitle")) {
            return this.questionContent;
        }
        return this.questionDetail;
    }

    private void setListRelation() throws Exception {
        String[] relations = this.question_.getRelations();
        if (relations != null && relations.length > 0) {
            for (String relation : relations) {
                Question ques = this.getFAQService().getQuestionById(relation);
                if (ques == null || !ques.isActivated() || !ques.isApproved()) continue;
                this.listQuestIdRela.add(relation);
                this.listRelationQuestion.add(ques.getQuestion());
            }
        }
    }

    public List<String> getListRelation() {
        return this.listRelationQuestion;
    }

    public List<String> getListIdQuesRela() {
        return this.listQuestIdRela;
    }

    public void setListIdQuesRela(List<String> listId) {
        this.listQuestIdRela = new ArrayList();
        this.listQuestIdRela.addAll(listId);
    }

    public void setListRelationQuestion(List<String> listQuestionContent) {
        this.listRelationQuestion.clear();
        this.listRelationQuestion.addAll(listQuestionContent);
    }

    protected List<String> getListRelationQuestion() {
        return this.listRelationQuestion;
    }

    public void updateChildOfQuestionManager(boolean isChild) {
        this.isChildOfQuestionManager_ = isChild;
        this.removeChildById(RESPONSE_CONTENT);
        this.removeChildById(QUESTION_LANGUAGE);
        this.removeChildById(IS_APPROVED);
        this.removeChildById(SHOW_ANSWER);
        this.inputResponseQuestion_.setValue((Object)"");
        this.listLanguageToReponse.clear();
        this.listQuestIdRela.clear();
        this.listRelationQuestion.clear();
    }

    private Answer[] updateDiscussForum(Answer[] answers) throws Exception {
        ForumService forumService;
        Topic topic;
        String topicId;
        if (this.faqSetting_.getIsDiscussForum() && (topicId = this.question_.getTopicIdDiscuss()) != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class)).getObjectNameById(topicId, Utils.TOPIC)) != null) {
            String[] ids = topic.getPath().split("/");
            int t = ids.length;
            String linkForum = FAQUtils.getLinkDiscuss((String)topicId);
            int l = answers.length;
            String remoteAddr = WebUIUtils.getRemoteIP();
            for (int i = 0; i < l; ++i) {
                String postId = answers[i].getPostId();
                try {
                    Post post;
                    if (postId != null && postId.length() > 0) {
                        post = forumService.getPost(ids[t - 3], ids[t - 2], topicId, postId);
                        if (post == null) {
                            post = new Post();
                            post.setOwner(answers[i].getResponseBy());
                            post.setName("Re: " + this.question_.getQuestion());
                            post.setIcon("ViewIcon");
                            answers[i].setPostId(post.getId());
                            post.setMessage(answers[i].getResponses());
                            post.setLink(linkForum);
                            post.setIsApproved(!topic.getIsModeratePost());
                            post.setRemoteAddr(remoteAddr);
                            forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, new MessageBuilder());
                            continue;
                        }
                        post.setIsApproved(!topic.getIsModeratePost());
                        post.setMessage(answers[i].getResponses());
                        forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, false, new MessageBuilder());
                        continue;
                    }
                    post = new Post();
                    post.setOwner(answers[i].getResponseBy());
                    post.setName("Re: " + this.question_.getQuestion());
                    post.setIcon("ViewIcon");
                    post.setMessage(answers[i].getResponses());
                    post.setLink(linkForum);
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setRemoteAddr(remoteAddr);
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, new MessageBuilder());
                    answers[i].setPostId(post.getId());
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)"Can not discuss question into forum, exception: ", (Throwable)e);
                }
            }
        }
        return answers;
    }

    static /* synthetic */ UIFormSelectBox access$000(UIResponseForm x0) {
        return x0.questionLanguages_;
    }

    static /* synthetic */ UIFormRichtextInput access$100(UIResponseForm x0) {
        return x0.inputResponseQuestion_;
    }

    static /* synthetic */ void access$200(UIResponseForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ List access$300(UIResponseForm x0) {
        return x0.listQuestIdRela;
    }

    static /* synthetic */ FAQSetting access$400(UIResponseForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ Answer[] access$500(UIResponseForm x0, Answer[] x1) throws Exception {
        return x0.updateDiscussForum(x1);
    }

    static /* synthetic */ Log access$600(UIResponseForm x0) {
        return x0.log;
    }

    static /* synthetic */ FAQService access$700(UIResponseForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ FAQService access$800(UIResponseForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ boolean access$900(UIResponseForm x0) {
        return x0.isModerator;
    }

    static /* synthetic */ boolean access$1000(UIResponseForm x0) {
        return x0.isAnswerApproved;
    }

    static /* synthetic */ void access$1100(UIResponseForm x0, String x1, boolean x2) {
        x0.info(x1, x2);
    }

    static /* synthetic */ Log access$1200(UIResponseForm x0) {
        return x0.log;
    }

    static /* synthetic */ void access$1300(UIResponseForm x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ Log access$1400(UIResponseForm x0) {
        return x0.log;
    }

    static /* synthetic */ boolean access$1500(UIResponseForm x0) {
        return x0.isChildOfQuestionManager_;
    }

    static /* synthetic */ String access$1600(UIResponseForm x0) {
        return x0.currentLanguage;
    }

    static /* synthetic */ UIComponent access$1700(UIResponseForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$1800(UIResponseForm x0) {
        return x0.listRelationQuestion;
    }

    static /* synthetic */ String access$1602(UIResponseForm x0, String x1) {
        x0.currentLanguage = x1;
        return x0.currentLanguage;
    }

    static /* synthetic */ Question access$1900(UIResponseForm x0) {
        return x0.question_;
    }

    static /* synthetic */ String access$2002(UIResponseForm x0, String x1) {
        x0.questionDetail = x1;
        return x0.questionDetail;
    }

    static /* synthetic */ String access$2102(UIResponseForm x0, String x1) {
        x0.questionContent = x1;
        return x0.questionContent;
    }

    static /* synthetic */ void access$2200(UIResponseForm x0, String x1) {
        x0.setValueTextInput(x1);
    }
}

