/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.answer.rendering.RenderHelper;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.faq.service.CategoryInfo;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.webui.FAQResourceResolver;
import org.exoplatform.faq.webui.UIFAQPortlet;
import org.exoplatform.faq.webui.UIViewer;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.utils.TimeConvertUtils;

@ComponentConfig(events={@EventConfig(listeners={ViewProfileActionListener.class}), @EventConfig(listeners={ChangePathActionListener.class})})
public class UIViewer
extends UIContainer {
    private FAQService fAqService;
    private String path = "categories";
    protected boolean useAjax = false;
    private Map<String, String> dataLinks = new HashMap();
    private RenderHelper renderHelper = new RenderHelper();
    private static String PORTLET_URL = null;

    public UIViewer() {
        this.fAqService = (FAQService)CommonUtils.getComponent(FAQService.class);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isInSpace() {
        return ((UIFAQPortlet)this.getAncestorOfType(UIFAQPortlet.class)).isInSpace();
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected List<String> arrangeList(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>();
        if (list.isEmpty() || list.size() == 0) {
            newList.add("<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"categories\"/>");
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (i == list.size() - 1) {
                    newList.add("<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + list.get(i) + "\"/>");
                    continue;
                }
                newList.add(list.get(i));
            }
        }
        return newList;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return new FAQResourceResolver();
    }

    public String getTemplate() {
        return "FAQViewerTemplate";
    }

    protected CategoryInfo getCategoryInfo() throws Exception {
        this.useAjax = FAQUtils.getUseAjaxFAQPortlet();
        if (this.isInSpace()) {
            this.path = ((UIFAQPortlet)this.getAncestorOfType(UIFAQPortlet.class)).getPathOfCateSpace();
        }
        return this.fAqService.getCategoryInfo(this.path, FAQUtils.getCategoriesIdFAQPortlet());
    }

    protected String getDisplaySpaceName() {
        return ((UIFAQPortlet)this.getAncestorOfType(UIFAQPortlet.class)).getDisplaySpaceName();
    }

    protected String render(String s) {
        Question question = new Question();
        question.setDetail(s);
        return this.renderHelper.renderQuestion(question);
    }

    protected String getURL(String path) {
        String id = path.substring(path.lastIndexOf("/") + 1);
        this.dataLinks.put(id, path);
        if (PORTLET_URL == null) {
            PORTLET_URL = FAQUtils.getPortletURI();
        }
        return new StringBuffer(PORTLET_URL).append("/?categoryId=").append(id).toString();
    }

    public void setCategoryId(String categoryId) throws Exception {
        String path = (String)this.dataLinks.get(categoryId);
        this.path = FAQUtils.isFieldEmpty((String)path) ? this.fAqService.getCategoryById(categoryId).getPath() : path;
    }

    protected String convertXTimeAgo(Date date) {
        return TimeConvertUtils.convertXTimeAgo((Date)date, (String)"EEE, MMM dd, yyyy", (int)TimeConvertUtils.DAY);
    }
}

