/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.UIAddRelationForm;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.CategoryTree;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/popup/UIAddRelationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIAddRelationForm
extends BaseUIFAQForm
implements UIPopupComponent {
    private List<Question> listQuestion = new ArrayList();
    private List<String> quesIdsSelect = new ArrayList();
    private String questionId_;
    private FAQSetting faqSetting_ = new FAQSetting();
    private CategoryTree categoryTree = null;

    public void activate() {
    }

    public void deActivate() {
    }

    public UIAddRelationForm() throws Exception {
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        this.getFAQService().getUserSetting(FAQUtils.getCurrentUser(), this.faqSetting_);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public void setRelationed(List<String> listRelation) {
        this.quesIdsSelect = listRelation;
    }

    public void setQuestionId(String questionId) {
        this.questionId_ = questionId;
        try {
            this.categoryTree = this.getFAQService().buildCategoryTree(null);
        }
        catch (Exception e) {
            this.categoryTree = new CategoryTree();
        }
    }

    protected String renderCategoryTree() throws Exception {
        this.listQuestion.clear();
        return this.renderCategoryTree(this.categoryTree);
    }

    private String renderCategoryTree(CategoryTree categoryTree) throws Exception {
        StringBuilder builder = new StringBuilder();
        Category category = categoryTree.getCategory();
        String categoryId = category.getId();
        if (FAQUtils.hasPermission((Category)category)) {
            List categoryTrees = categoryTree.getSubCategory();
            List questions = this.getQuestionsByCategoryId(categoryId, this.faqSetting_);
            String clazz = "collapseIcon";
            if (categoryTrees.size() == 0 && questions.size() == 0) {
                clazz = "uiIconEmpty";
            }
            builder.append("<a href=\"javascript:void(0);\"");
            if (!categoryId.equals("categories")) {
                builder.append(" class=\"uiIconNode ").append(clazz).append("\" onclick=\"eXo.answer.AnswerUtils.showTreeNode(this);\">").append("<i class=\"uiIconCategory uiIconLightGray\"></i>").append(category.getName());
            } else {
                String home = this.i18n("UICategoryTree.label.home");
                builder.append(">").append("<i class=\"uiIconHome uiIconLightGray\"></i> <span>").append(home).append("</span>");
            }
            builder.append("</a>");
            this.listQuestion.addAll(questions);
            if (categoryTrees.size() > 0 || questions.size() > 0) {
                builder.append("<ul class=\"nodeGroup\" style=\"display: block; \">");
                for (Question question : questions) {
                    if (this.questionId_.equals(question.getPath())) continue;
                    boolean isChecked = false;
                    if (this.quesIdsSelect.contains(question.getId())) {
                        isChecked = true;
                    }
                    String questionName = question.getQuestion();
                    this.addUIFormInput((UIFormInput)new UICheckBoxInput(question.getId(), question.getId(), Boolean.valueOf(isChecked)));
                    builder.append("<li class=\"node\">").append("<span class=\"uiCheckbox mgl0\"><input name=\"").append(question.getId()).append("\" id=\"").append(question.getId()).append("\" type=\"checkbox\"").append(isChecked ? " checked" : "").append("/><span title=\"").append(questionName).append("\">").append(FAQUtils.getSubString((String)questionName, (int)20)).append("</span></span>");
                    builder.append("</li>");
                }
                for (CategoryTree subTree : categoryTrees) {
                    builder.append("<li class=\"node\">");
                    builder.append(this.renderCategoryTree(subTree));
                    builder.append("</li>");
                }
                builder.append("</ul>");
            }
        }
        return builder.toString();
    }

    private List<Question> getQuestionsByCategoryId(String categoryId, FAQSetting faqSetting) throws Exception {
        ArrayList<Question> listQuestions = new ArrayList();
        listQuestions = this.getFAQService().getAllQuestionsByCatetory(categoryId, faqSetting).getAll();
        return listQuestions;
    }

    static /* synthetic */ List access$000(UIAddRelationForm x0) {
        return x0.listQuestion;
    }

    static /* synthetic */ FAQService access$100(UIAddRelationForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ void access$200(UIAddRelationForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ void access$300(UIAddRelationForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

