/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appCenter.services.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.appCenter.services.entity.jpa.Application;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.organization.Group;

public class ApplicationDAO
extends GenericDAOJPAImpl<Application, Long> {
    public List<Application> getAuthorizedApplications(String userName, Collection<Group> groups, String keyword) {
        try {
            ArrayList results = new ArrayList();
            groups.forEach(group -> results.addAll(this.getEntityManager().createNamedQuery("ApplicationEntity.getAuthorizedApplications").setParameter("permissionPattern1", (Object)("%:" + group.getId())).setParameter("permissionPattern2", (Object)("%:" + group.getId() + ",%")).getResultList()));
            return results.stream().distinct().filter(app -> StringUtils.containsIgnoreCase((CharSequence)app.getTitle(), (CharSequence)keyword) || StringUtils.containsIgnoreCase((CharSequence)app.getDescription(), (CharSequence)keyword)).collect(Collectors.toList());
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Application> getDefaultApplications(String userName, Collection<Group> groups) {
        try {
            ArrayList results = new ArrayList();
            groups.forEach(group -> results.addAll(this.getEntityManager().createNamedQuery("ApplicationEntity.getDefaultApplications").setParameter("permissionPattern1", (Object)("%:" + group.getId())).setParameter("permissionPattern2", (Object)("%:" + group.getId() + ",%")).getResultList()));
            return results.stream().distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Application getAppByTitleOrUrl(String title, String url) {
        try {
            return (Application)this.getEntityManager().createNamedQuery("ApplicationEntity.getAppByTitleOrUrl").setParameter("title", (Object)title).setParameter("url", (Object)url).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

