/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.util.Base64;
import org.exoplatform.appcenter.dao.ApplicationDAO;
import org.exoplatform.appcenter.dao.FavoriteApplicationDAO;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationImage;
import org.exoplatform.appcenter.dto.UserApplication;
import org.exoplatform.appcenter.entity.ApplicationEntity;
import org.exoplatform.appcenter.entity.FavoriteApplicationEntity;
import org.exoplatform.appcenter.service.ApplicationNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;

public class ApplicationCenterStorage {
    public static final String NAME_SPACE = "appCenter";
    private FileService fileService;
    private ApplicationDAO applicationDAO;
    private FavoriteApplicationDAO favoriteApplicationDAO;

    public ApplicationCenterStorage(ApplicationDAO applicationDAO, FavoriteApplicationDAO favoriteApplicationDAO, FileService fileService) {
        this.applicationDAO = applicationDAO;
        this.favoriteApplicationDAO = favoriteApplicationDAO;
        this.fileService = fileService;
    }

    public Application getApplicationByTitle(String title) throws FileStorageException {
        if (StringUtils.isBlank((String)title)) {
            throw new IllegalArgumentException("title is mandatory");
        }
        ApplicationEntity applicationentity = this.applicationDAO.getApplicationByTitle(title);
        return this.toDTO(applicationentity);
    }

    public Application createApplication(Application applicationForm) throws Exception {
        if (applicationForm == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        ApplicationEntity applicationEntity = this.toEntity(applicationForm);
        applicationEntity.setId(null);
        ApplicationImage applicationImage = this.createAppImageFileItem(applicationForm.getImageFileName(), applicationForm.getImageFileBody());
        if (applicationImage != null) {
            applicationEntity.setImageFileId(applicationImage.getId());
        }
        applicationEntity = (ApplicationEntity)this.applicationDAO.create(applicationEntity);
        return this.toDTO(applicationEntity);
    }

    public Application updateApplication(Application application) throws Exception {
        boolean newImageAttached;
        if (application == null) {
            throw new IllegalArgumentException("application is mandatory");
        }
        Long applicationId = application.getId();
        ApplicationEntity storedApplicationEntity = (ApplicationEntity)this.applicationDAO.find(applicationId);
        if (storedApplicationEntity == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found");
        }
        application.setSystem(storedApplicationEntity.isSystem());
        Long oldImageFileId = storedApplicationEntity.getImageFileId();
        boolean imageRemoved = StringUtils.isBlank((String)application.getImageFileBody()) && StringUtils.isBlank((String)application.getImageFileName()) && oldImageFileId != null && oldImageFileId > 0L;
        boolean bl = newImageAttached = StringUtils.isNotBlank((String)application.getImageFileBody()) && StringUtils.isNotBlank((String)application.getImageFileName());
        if (newImageAttached) {
            ApplicationImage applicationImage = this.createAppImageFileItem(application.getImageFileName(), application.getImageFileBody());
            if (applicationImage != null) {
                application.setImageFileId(applicationImage.getId());
                if (oldImageFileId != null && oldImageFileId > 0L) {
                    this.fileService.deleteFile(oldImageFileId.longValue());
                }
            }
        } else {
            application.setImageFileId(oldImageFileId);
        }
        if (imageRemoved) {
            application.setImageFileId(null);
            this.fileService.deleteFile(oldImageFileId.longValue());
        }
        if (application.isMandatory()) {
            this.favoriteApplicationDAO.removeAllFavoritesOfApplication(application.getId());
        }
        ApplicationEntity applicationEntity = this.toEntity(application);
        applicationEntity = (ApplicationEntity)this.applicationDAO.update(applicationEntity);
        return this.toDTO(applicationEntity);
    }

    public void deleteApplication(long applicationId) throws ApplicationNotFoundException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        ApplicationEntity applicationEntity = (ApplicationEntity)this.applicationDAO.find(Long.valueOf(applicationId));
        if (applicationEntity == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " not found");
        }
        this.applicationDAO.delete(applicationEntity);
    }

    public Application getApplicationById(long applicationId) throws FileStorageException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        ApplicationEntity applicationEntity = (ApplicationEntity)this.applicationDAO.find(Long.valueOf(applicationId));
        return this.toDTO(applicationEntity);
    }

    public void addApplicationToUserFavorite(long applicationId, String username) throws ApplicationNotFoundException {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        ApplicationEntity application = (ApplicationEntity)this.applicationDAO.find(Long.valueOf(applicationId));
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id " + applicationId + " wasn't found in store");
        }
        this.favoriteApplicationDAO.create(new FavoriteApplicationEntity(application, username));
    }

    public void updateFavoriteApplicationOrder(long applicationId, String username, Long order) {
        FavoriteApplicationEntity entity = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (entity != null && !entity.getApplication().isMandatory()) {
            entity.setOrder((long)order);
            this.favoriteApplicationDAO.update(entity);
        }
    }

    public void deleteApplicationFavorite(Long applicationId, String username) {
        if (applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        FavoriteApplicationEntity applicationFavorite = this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username);
        if (applicationFavorite != null) {
            this.favoriteApplicationDAO.delete(applicationFavorite);
        }
    }

    public List<UserApplication> getMandatoryApplications() {
        List<ApplicationEntity> applications = this.applicationDAO.getMandatoryActiveApps();
        ArrayList<UserApplication> list = new ArrayList<UserApplication>();
        for (ApplicationEntity application : applications) {
            UserApplication userApplication = null;
            try {
                userApplication = this.toUserApplicationDTO(application);
            }
            catch (FileStorageException e) {
                e.printStackTrace();
            }
            list.add(userApplication);
        }
        return list;
    }

    public List<UserApplication> getFavoriteApplicationsByUser(String username) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        List<FavoriteApplicationEntity> applications = this.favoriteApplicationDAO.getFavoriteAppsByUser(username);
        return applications.stream().map(this::toUserApplicationDTO).filter(userApplication -> userApplication.isActive() && !userApplication.isMandatory()).collect(Collectors.toList());
    }

    public List<Application> getSystemApplications() throws FileStorageException {
        List<ApplicationEntity> applications = this.applicationDAO.getSystemApplications();
        ArrayList<Application> list = new ArrayList<Application>();
        Application application = null;
        for (ApplicationEntity entity : applications) {
            application = this.toDTO(entity);
            list.add(application);
        }
        return list;
    }

    public boolean isFavoriteApplication(Long applicationId, String username) {
        if (applicationId == null || applicationId <= 0L) {
            throw new IllegalArgumentException("applicationId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        return this.favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationId, username) != null;
    }

    public long countFavorites(String username) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        return this.favoriteApplicationDAO.countFavoritesForUser(username);
    }

    public ApplicationImage saveAppImageFileItem(ApplicationImage defaultAppImage) throws Exception {
        if (defaultAppImage == null) {
            throw new IllegalArgumentException("Application image is mandatory");
        }
        if (defaultAppImage.getId() == null || defaultAppImage.getId() <= 0L) {
            return this.createAppImageFileItem(defaultAppImage.getFileName(), defaultAppImage.getFileBody());
        }
        return this.updateAppImageFileItem(defaultAppImage.getId(), defaultAppImage.getFileName(), defaultAppImage.getFileBody());
    }

    public ApplicationImage createAppImageFileItem(String fileName, String fileBody) throws Exception {
        return this.updateAppImageFileItem(null, fileName, fileBody);
    }

    public Long getApplicationImageLastUpdated(long fileId) throws FileStorageException {
        FileItem fileItem = this.fileService.getFile(fileId);
        if (fileItem != null && fileItem.getFileInfo().getUpdatedDate() != null) {
            return fileItem.getFileInfo().getUpdatedDate().getTime();
        }
        return null;
    }

    public InputStream getApplicationImageInputStream(long fileId) throws FileStorageException, IOException {
        FileItem fileItem = this.fileService.getFile(fileId);
        if (fileItem != null && fileItem.getAsByte() != null) {
            return new ByteArrayInputStream(fileItem.getAsByte());
        }
        return null;
    }

    public ApplicationImage getAppImageFile(Long fileId) throws FileStorageException {
        FileItem fileItem = this.fileService.getFile(fileId.longValue());
        if (fileItem != null) {
            byte[] bytes = fileItem.getAsByte();
            String fileBody = new String(Base64.encode((byte[])bytes), Charset.defaultCharset());
            String fileName = fileItem.getFileInfo().getName();
            return new ApplicationImage(fileId, fileName, fileBody);
        }
        return null;
    }

    public List<Application> getApplications(String keyword) throws FileStorageException {
        List<ApplicationEntity> applications = this.applicationDAO.getApplications(keyword);
        ArrayList<Application> list = new ArrayList<Application>();
        for (ApplicationEntity entity : applications) {
            Application application = this.toDTO(entity);
            list.add(application);
        }
        return list;
    }

    public long countApplications() {
        return this.applicationDAO.count();
    }

    private Application toDTO(ApplicationEntity applicationEntity) throws FileStorageException {
        if (applicationEntity == null) {
            return null;
        }
        String imageFileName = applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() > 0L ? this.fileService.getFile(applicationEntity.getImageFileId().longValue()).getFileInfo().getName() : null;
        String[] permissions = StringUtils.split((String)applicationEntity.getPermissions(), (String)",");
        Application application = new Application(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.getHelpPageUrl(), applicationEntity.getImageFileId(), null, imageFileName, applicationEntity.getDescription(), applicationEntity.isSystem(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isMobile(), permissions);
        application.setSystem(applicationEntity.isSystem());
        application.setHelpPageURL(applicationEntity.getHelpPageUrl());
        application.setIsMobile(applicationEntity.isMobile());
        return application;
    }

    private UserApplication toUserApplicationDTO(ApplicationEntity applicationEntity) throws FileStorageException {
        if (applicationEntity == null) {
            return null;
        }
        String imageFileName = applicationEntity.getImageFileId() != null && applicationEntity.getImageFileId() > 0L ? this.fileService.getFile(applicationEntity.getImageFileId().longValue()).getFileInfo().getName() : null;
        String[] permissions = StringUtils.split((String)applicationEntity.getPermissions(), (String)",");
        UserApplication userApplication = new UserApplication(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.getHelpPageUrl(), applicationEntity.getImageFileId(), null, imageFileName, applicationEntity.getDescription(), applicationEntity.isSystem(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isMobile(), false, permissions);
        userApplication.setSystem(applicationEntity.isSystem());
        userApplication.setHelpPageURL(applicationEntity.getHelpPageUrl());
        userApplication.setIsMobile(applicationEntity.isMobile());
        return userApplication;
    }

    private UserApplication toUserApplicationDTO(FavoriteApplicationEntity favoriteApplicationEntity) {
        if (favoriteApplicationEntity == null) {
            return null;
        }
        ApplicationEntity applicationEntity = favoriteApplicationEntity.getApplication();
        String[] permissions = StringUtils.split((String)applicationEntity.getPermissions(), (String)",");
        UserApplication userApplication = new UserApplication(applicationEntity.getId(), applicationEntity.getTitle(), applicationEntity.getUrl(), applicationEntity.getHelpPageUrl(), applicationEntity.getImageFileId(), null, null, applicationEntity.getDescription(), applicationEntity.isSystem(), applicationEntity.isActive(), applicationEntity.isMandatory(), applicationEntity.isMobile(), true, permissions);
        userApplication.setOrder(favoriteApplicationEntity.getOrder());
        userApplication.setSystem(applicationEntity.isSystem());
        userApplication.setHelpPageURL(applicationEntity.getHelpPageUrl());
        userApplication.setIsMobile(applicationEntity.isMobile());
        return userApplication;
    }

    private ApplicationEntity toEntity(Application application) {
        if (application == null) {
            return null;
        }
        ApplicationEntity applicationEntity = new ApplicationEntity(application.getId(), application.getTitle(), application.getUrl(), application.getImageFileId(), application.getDescription(), application.isActive(), application.isMandatory(), StringUtils.join(application.getPermissions(), (String)","));
        applicationEntity.setSystem(application.isSystem());
        applicationEntity.setHelpPageUrl(application.getHelpPageURL());
        applicationEntity.setIsMobile(application.isMobile());
        return applicationEntity;
    }

    private ApplicationImage updateAppImageFileItem(Long fileId, String fileName, String fileBody) throws Exception {
        byte[] bytesContent;
        byte[] decodedBytes;
        if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)fileBody)) {
            return null;
        }
        String fileContent = fileBody;
        if (fileBody.contains("base64,")) {
            String[] file = fileBody.split("base64,");
            fileContent = file[1];
        }
        if ((decodedBytes = Base64.decode((byte[])(bytesContent = fileContent.getBytes(Charset.defaultCharset().name())))) != null) {
            bytesContent = decodedBytes;
        }
        FileItem fileItem = new FileItem(fileId, fileName, "image/png", NAME_SPACE, (long)bytesContent.length, new Date(), null, false, (InputStream)new ByteArrayInputStream(bytesContent));
        fileItem = fileId != null && fileId > 0L ? this.fileService.updateFile(fileItem) : this.fileService.writeFile(fileItem);
        Long id = fileItem == null || fileItem.getFileInfo() == null ? null : fileItem.getFileInfo().getId();
        return new ApplicationImage(id, fileName, fileBody);
    }
}

