/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.appcenter.entity.FavoriteApplicationEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FavoriteApplicationDAO
extends GenericDAOJPAImpl<FavoriteApplicationEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(FavoriteApplicationDAO.class);

    public List<FavoriteApplicationEntity> getFavoriteAppsByUser(String userName) {
        return this.getEntityManager().createNamedQuery("FavoriteApplicationEntity.getFavoriteAppsByUser", FavoriteApplicationEntity.class).setParameter("userName", (Object)userName).getResultList();
    }

    public FavoriteApplicationEntity getFavoriteAppByUserNameAndAppId(Long applicationId, String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("FavoriteApplicationEntity.getFavoriteAppByUserNameAndAppId", FavoriteApplicationEntity.class).setParameter("applicationId", (Object)applicationId).setParameter("userName", (Object)userName);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one application was found with applicationId '{}' and userName '{}'", new Object[]{applicationId, userName});
            return (FavoriteApplicationEntity)result.get(0);
        }
        return (FavoriteApplicationEntity)result.get(0);
    }

    public long countFavoritesForUser(String username) {
        TypedQuery query = this.getEntityManager().createNamedQuery("FavoriteApplicationEntity.countFavoritesByUser", Long.class);
        query.setParameter("userName", (Object)username);
        return (Long)query.getSingleResult();
    }

    public void removeAllFavoritesOfApplication(Long applicationId) {
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().createQuery("DELETE FROM FavoriteApplicationEntity favoriteApp WHERE favoriteApp.application.id = :applicationId ").setParameter("applicationId", (Object)applicationId).executeUpdate();
        this.getEntityManager().getTransaction().commit();
    }
}

