/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.exoplatform.appcenter.entity.ApplicationEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="FavoriteApplicationEntity")
@ExoEntity
@Table(name="AC_FAVORITE_APPLICATION")
@NamedQueries(value={@NamedQuery(name="FavoriteApplicationEntity.getFavoriteAppByUserNameAndAppId", query="SELECT distinct(favoriteApp) FROM FavoriteApplicationEntity favoriteApp  WHERE favoriteApp.application.id = :applicationId AND favoriteApp.userName = :userName"), @NamedQuery(name="FavoriteApplicationEntity.getFavoriteAppsByAppId", query="SELECT distinct(favoriteApp) FROM FavoriteApplicationEntity favoriteApp  WHERE favoriteApp.application.id = :applicationId"), @NamedQuery(name="FavoriteApplicationEntity.countFavoritesByUser", query="SELECT count(*) FROM FavoriteApplicationEntity favoriteApp  WHERE favoriteApp.userName = :userName"), @NamedQuery(name="FavoriteApplicationEntity.getFavoriteAppsByUser", query="SELECT favoriteApp FROM FavoriteApplicationEntity favoriteApp WHERE favoriteApp.userName = :userName ORDER BY favoriteApp.order NULLS LAST")})
public class FavoriteApplicationEntity {
    @Id
    @SequenceGenerator(name="SEQ_FAVORITE_APPLICATION_ID", sequenceName="SEQFAVORITE_APPLICATION_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_FAVORITE_APPLICATION_ID")
    @Column(name="ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="APPLICATION_ID")
    private ApplicationEntity application;
    @Column(name="USER_NAME")
    private String userName;
    @Column(name="APPLICATION_ORDER")
    private Long order;

    public FavoriteApplicationEntity() {
    }

    public FavoriteApplicationEntity(ApplicationEntity application, String userName) {
        this.application = application;
        this.userName = userName;
    }

    public FavoriteApplicationEntity(ApplicationEntity application, String userName, Long order) {
        this.application = application;
        this.userName = userName;
        this.order = order;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ApplicationEntity getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationEntity application) {
        this.application = application;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getOrder() {
        return this.order;
    }

    public void setOrder(Long order) {
        this.order = order;
    }
}

