/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.dao;

import java.util.List;
import org.exoplatform.appcenter.dao.ApplicationDAO;
import org.exoplatform.appcenter.dao.FavoriteApplicationDAO;
import org.exoplatform.appcenter.entity.ApplicationEntity;
import org.exoplatform.appcenter.entity.FavoriteApplicationEntity;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApplicationDAOTest {
    private PortalContainer container;

    @BeforeClass
    public static void startDB() {
        RootContainer rootContainer = RootContainer.getInstance();
        InitialContextInitializer initializer = (InitialContextInitializer)rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        initializer.recall();
    }

    @Before
    public void setup() {
        this.container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)this.container);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    @After
    public void teardown() {
        ApplicationDAO service = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        service.deleteAll();
        RequestLifeCycle.end();
        this.container.stop();
        this.container = null;
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testServiceInitialized() {
        ApplicationDAO service = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)service);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        ApplicationEntity storedEntity = (ApplicationEntity)service.create((Object)applicationEntity);
        Assert.assertNotNull((Object)storedEntity);
        Assert.assertNotNull((Object)storedEntity.getId());
        Assert.assertEquals((Object)applicationEntity.getTitle(), (Object)storedEntity.getTitle());
        Assert.assertEquals((Object)applicationEntity.getUrl(), (Object)storedEntity.getUrl());
        Assert.assertEquals((Object)applicationEntity.getImageFileId(), (Object)storedEntity.getImageFileId());
        Assert.assertEquals((Object)applicationEntity.getDescription(), (Object)storedEntity.getDescription());
        Assert.assertEquals((Object)applicationEntity.isActive(), (Object)storedEntity.isActive());
        Assert.assertEquals((Object)applicationEntity.isMandatory(), (Object)storedEntity.isMandatory());
        Assert.assertEquals((Object)applicationEntity.getPermissions(), (Object)storedEntity.getPermissions());
        applicationEntity = new ApplicationEntity();
        applicationEntity.setId(null);
        applicationEntity.setTitle("title");
        applicationEntity.setUrl("url");
        applicationEntity.setImageFileId(Long.valueOf(5L));
        applicationEntity.setDescription("description");
        applicationEntity.setActive(false);
        applicationEntity.setMandatory(true);
        applicationEntity.setPermissions("permissions");
        storedEntity = (ApplicationEntity)service.create((Object)applicationEntity);
        Assert.assertNotNull((Object)storedEntity);
        Assert.assertNotNull((Object)storedEntity.getId());
        Assert.assertEquals((Object)applicationEntity.getTitle(), (Object)storedEntity.getTitle());
        Assert.assertEquals((Object)applicationEntity.getUrl(), (Object)storedEntity.getUrl());
        Assert.assertEquals((Object)applicationEntity.getImageFileId(), (Object)storedEntity.getImageFileId());
        Assert.assertEquals((Object)applicationEntity.getDescription(), (Object)storedEntity.getDescription());
        Assert.assertEquals((Object)applicationEntity.isActive(), (Object)storedEntity.isActive());
        Assert.assertEquals((Object)applicationEntity.isMandatory(), (Object)storedEntity.isMandatory());
        Assert.assertEquals((Object)applicationEntity.getPermissions(), (Object)storedEntity.getPermissions());
    }

    @Test
    public void testFindApplications() {
        ApplicationDAO service = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)service);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        applicationEntity = (ApplicationEntity)service.create((Object)applicationEntity);
        ApplicationEntity applicationEntity2 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, false, "permissions", false);
        applicationEntity2 = (ApplicationEntity)service.create((Object)applicationEntity2);
        List applications = service.getApplications("title");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)2L, (long)applications.size());
        Assert.assertEquals((Object)applicationEntity.getId(), (Object)((ApplicationEntity)applications.get(0)).getId());
        applications = service.getApplications("title*");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)2L, (long)applications.size());
        Assert.assertEquals((Object)applicationEntity.getId(), (Object)((ApplicationEntity)applications.get(0)).getId());
        Assert.assertEquals((Object)applicationEntity2.getId(), (Object)((ApplicationEntity)applications.get(1)).getId());
        applications = service.getApplications("title*");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)2L, (long)applications.size());
        applications = service.getApplications("title2");
        Assert.assertNotNull((Object)applications);
        Assert.assertEquals((long)1L, (long)applications.size());
        Assert.assertEquals((Object)applicationEntity2.getId(), (Object)((ApplicationEntity)applications.get(0)).getId());
    }

    @Test
    public void testGetApplicationByTitle() {
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)applicationDAO);
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        Assert.assertNotNull((Object)favoriteApplicationDAO);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        applicationDAO.create((Object)applicationEntity);
        ApplicationEntity applicationEntity2 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, false, "permissions", false);
        applicationDAO.create((Object)applicationEntity2);
        ApplicationEntity foundEntity = applicationDAO.getApplicationByTitle("title");
        Assert.assertNotNull((Object)foundEntity);
        Assert.assertEquals((Object)applicationEntity.getId(), (Object)foundEntity.getId());
        foundEntity = applicationDAO.getApplicationByTitle("title2");
        Assert.assertNotNull((Object)foundEntity);
        Assert.assertEquals((Object)applicationEntity2.getId(), (Object)foundEntity.getId());
        foundEntity = applicationDAO.getApplicationByTitle("title3");
        Assert.assertNull((Object)foundEntity);
    }

    @Test
    public void testGetFavoriteApps() {
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)applicationDAO);
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        Assert.assertNotNull((Object)favoriteApplicationDAO);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        applicationEntity = (ApplicationEntity)applicationDAO.create((Object)applicationEntity);
        ApplicationEntity applicationEntity2 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, false, "permissions", false);
        applicationEntity2 = (ApplicationEntity)applicationDAO.create((Object)applicationEntity2);
        ApplicationEntity applicationEntity3 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, true, "permissions", false);
        applicationEntity3 = (ApplicationEntity)applicationDAO.create((Object)applicationEntity3);
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser2"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser3"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser4"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity2, "testuser"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity2, "testuser3"));
        List favorites = favoriteApplicationDAO.getFavoriteAppsByUser("testuser");
        Assert.assertNotNull((Object)favorites);
        Assert.assertEquals((long)2L, (long)favorites.size());
        favorites = favoriteApplicationDAO.getFavoriteAppsByUser("testuser2");
        Assert.assertNotNull((Object)favorites);
        Assert.assertEquals((long)1L, (long)favorites.size());
        favorites = favoriteApplicationDAO.getFavoriteAppsByUser("fake");
        Assert.assertNotNull((Object)favorites);
        Assert.assertEquals((long)0L, (long)favorites.size());
    }

    @Test
    public void testGetMandatoryApps() {
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)applicationDAO);
        ApplicationEntity applicationEntity1 = new ApplicationEntity(null, "title1", "url1", Long.valueOf(5L), "description1", true, true, "permissions", false);
        applicationDAO.create((Object)applicationEntity1);
        ApplicationEntity applicationEntity2 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, true, "permissions", false);
        applicationDAO.create((Object)applicationEntity2);
        ApplicationEntity applicationEntity3 = new ApplicationEntity(null, "title3", "url3", Long.valueOf(5L), "description3", false, true, "permissions", false);
        applicationDAO.create((Object)applicationEntity3);
        List mandatoryApps = applicationDAO.getMandatoryActiveApps();
        Assert.assertNotNull((Object)mandatoryApps);
        Assert.assertEquals((long)2L, (long)mandatoryApps.size());
    }
}

