/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.dao;

import org.exoplatform.appcenter.dao.ApplicationDAO;
import org.exoplatform.appcenter.dao.FavoriteApplicationDAO;
import org.exoplatform.appcenter.entity.ApplicationEntity;
import org.exoplatform.appcenter.entity.FavoriteApplicationEntity;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FavoriteApplicationDAOTest {
    private PortalContainer container;

    @BeforeClass
    public static void startDB() {
        RootContainer rootContainer = RootContainer.getInstance();
        InitialContextInitializer initializer = (InitialContextInitializer)rootContainer.getComponentInstanceOfType(InitialContextInitializer.class);
        initializer.recall();
    }

    @Before
    public void setup() {
        this.container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)this.container);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    @After
    public void teardown() {
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        favoriteApplicationDAO.deleteAll();
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        applicationDAO.deleteAll();
        RequestLifeCycle.end();
        this.container.stop();
        this.container = null;
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testServiceInitialized() {
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)applicationDAO);
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        Assert.assertNotNull((Object)favoriteApplicationDAO);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        applicationEntity = (ApplicationEntity)applicationDAO.create((Object)applicationEntity);
        FavoriteApplicationEntity favoriteApp = new FavoriteApplicationEntity();
        favoriteApp.setId(null);
        favoriteApp.setApplication(applicationEntity);
        favoriteApp.setUserName("testuser");
        favoriteApp = (FavoriteApplicationEntity)favoriteApplicationDAO.create((Object)favoriteApp);
        Assert.assertNotNull((Object)favoriteApp);
        Assert.assertNotNull((Object)favoriteApp.getId());
        Assert.assertNotNull((Object)favoriteApp.getApplication());
        Assert.assertEquals((Object)applicationEntity.getId(), (Object)favoriteApp.getApplication().getId());
        Assert.assertEquals((Object)"testuser", (Object)favoriteApp.getUserName());
    }

    @Test
    public void testGetFavoriteAppByUserNameAndAppId() {
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)applicationDAO);
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        Assert.assertNotNull((Object)favoriteApplicationDAO);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        applicationEntity = (ApplicationEntity)applicationDAO.create((Object)applicationEntity);
        ApplicationEntity applicationEntity2 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, false, "permissions", false);
        applicationEntity2 = (ApplicationEntity)applicationDAO.create((Object)applicationEntity2);
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser2"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser3"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser4"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity2, "testuser"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity2, "testuser3"));
        FavoriteApplicationEntity favoriteApp = favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationEntity.getId(), "testuser4");
        Assert.assertNotNull((Object)favoriteApp);
        Assert.assertNotNull((Object)favoriteApp.getId());
        Assert.assertNotNull((Object)favoriteApp.getApplication());
        Assert.assertEquals((Object)applicationEntity.getId(), (Object)favoriteApp.getApplication().getId());
        Assert.assertEquals((Object)"testuser4", (Object)favoriteApp.getUserName());
        favoriteApp = favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationEntity2.getId(), "testuser3");
        Assert.assertNotNull((Object)favoriteApp);
        Assert.assertNotNull((Object)favoriteApp.getId());
        Assert.assertNotNull((Object)favoriteApp.getApplication());
        Assert.assertEquals((Object)applicationEntity2.getId(), (Object)favoriteApp.getApplication().getId());
        Assert.assertEquals((Object)"testuser3", (Object)favoriteApp.getUserName());
        favoriteApp = favoriteApplicationDAO.getFavoriteAppByUserNameAndAppId(applicationEntity.getId(), "fake");
        Assert.assertNull((Object)favoriteApp);
    }

    @Test
    public void testCountFavoritesForUser() {
        ApplicationDAO applicationDAO = (ApplicationDAO)ExoContainerContext.getService(ApplicationDAO.class);
        Assert.assertNotNull((Object)applicationDAO);
        FavoriteApplicationDAO favoriteApplicationDAO = (FavoriteApplicationDAO)ExoContainerContext.getService(FavoriteApplicationDAO.class);
        Assert.assertNotNull((Object)favoriteApplicationDAO);
        ApplicationEntity applicationEntity = new ApplicationEntity(null, "title", "url", Long.valueOf(5L), "description", true, false, "permissions", false);
        applicationEntity = (ApplicationEntity)applicationDAO.create((Object)applicationEntity);
        ApplicationEntity applicationEntity2 = new ApplicationEntity(null, "title2", "url2", Long.valueOf(5L), "description2", true, false, "permissions", false);
        applicationEntity2 = (ApplicationEntity)applicationDAO.create((Object)applicationEntity2);
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser2"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser3"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity, "testuser4"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity2, "testuser"));
        favoriteApplicationDAO.create((Object)new FavoriteApplicationEntity(applicationEntity2, "testuser3"));
        Assert.assertEquals((long)2L, (long)favoriteApplicationDAO.countFavoritesForUser("testuser"));
        Assert.assertEquals((long)1L, (long)favoriteApplicationDAO.countFavoritesForUser("testuser2"));
        Assert.assertEquals((long)2L, (long)favoriteApplicationDAO.countFavoritesForUser("testuser3"));
        Assert.assertEquals((long)1L, (long)favoriteApplicationDAO.countFavoritesForUser("testuser4"));
    }
}

