/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.rest;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.exoplatform.appcenter.dto.Application;
import org.exoplatform.appcenter.dto.ApplicationList;
import org.exoplatform.appcenter.dto.GeneralSettings;
import org.exoplatform.appcenter.rest.ApplicationCenterREST;
import org.exoplatform.appcenter.service.ApplicationCenterService;
import org.exoplatform.container.PortalContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ApplicationCenterRestServiceTest {
    @Mock
    private ApplicationCenterService applicationCenterService;
    @Mock
    private PortalContainer portalContainer;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.portalContainer.getName()).thenReturn((Object)"portal");
        Mockito.when((Object)this.portalContainer.getRestContextName()).thenReturn((Object)"rest");
    }

    @Test
    public void testGetApplicationsList() throws Exception {
        ApplicationList result = new ApplicationList();
        ArrayList<Application> resultList = new ArrayList<Application>();
        resultList.add(new Application(Long.valueOf(1L), "titre1", "url1", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description1", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(2L), "titre2", "url2", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description2", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(3L), "titre3", "url3", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description3", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(4L), "titre4", "url4", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description4", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(5L), "titre5", "url5", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description5", false, true, false, true, false, new String[]{""}));
        result.setApplications(resultList);
        Mockito.when((Object)this.applicationCenterService.getApplicationsList(0, 10, "")).thenReturn((Object)result);
        ApplicationCenterREST applicationCenterREST = new ApplicationCenterREST(this.applicationCenterService, this.portalContainer);
        Response response = applicationCenterREST.getApplicationsList(0, 10, "");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)resultList.size(), (long)((ApplicationList)response.getEntity()).getApplications().size());
    }

    @Test
    public void testGetAuthorizedApplicationsList() throws Exception {
        ApplicationList result = new ApplicationList();
        ArrayList<Application> resultList = new ArrayList<Application>();
        resultList.add(new Application(Long.valueOf(1L), "titre1", "url1", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description1", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(2L), "titre2", "url2", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description2", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(3L), "titre3", "url3", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description3", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(4L), "titre4", "url4", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description4", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(5L), "titre5", "url5", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description5", false, true, false, true, false, new String[]{""}));
        result.setApplications(resultList);
        Mockito.when((Object)this.applicationCenterService.getAuthorizedApplicationsList(0, 10, "", null)).thenReturn((Object)result);
        ApplicationCenterREST applicationCenterREST = new ApplicationCenterREST(this.applicationCenterService, this.portalContainer);
        Response response = applicationCenterREST.getAuthorizedApplicationsList(0, 10, "");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)resultList.size(), (long)((ApplicationList)response.getEntity()).getApplications().size());
    }

    @Test
    public void testGetFavoriteApplicationsList() throws Exception {
        ApplicationList result = new ApplicationList();
        ArrayList<Application> resultList = new ArrayList<Application>();
        resultList.add(new Application(Long.valueOf(1L), "titre1", "url1", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description1", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(2L), "titre2", "url2", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description2", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(3L), "titre3", "url3", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description3", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(4L), "titre4", "url4", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description4", false, true, false, true, false, new String[]{""}));
        resultList.add(new Application(Long.valueOf(5L), "titre5", "url5", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description5", false, true, false, true, false, new String[]{""}));
        result.setApplications(resultList);
        Mockito.when((Object)this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(null)).thenReturn((Object)result);
        ApplicationCenterREST applicationCenterREST = new ApplicationCenterREST(this.applicationCenterService, this.portalContainer);
        Response response = applicationCenterREST.getFavoriteApplicationsList();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)resultList.size(), (long)((ApplicationList)response.getEntity()).getApplications().size());
    }

    @Test
    public void testLogFunctions() throws Exception {
        ApplicationCenterREST applicationCenterREST = new ApplicationCenterREST(this.applicationCenterService, this.portalContainer);
        Response response = applicationCenterREST.logClickAllApplications();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Application application = new Application(Long.valueOf(1L), "titre1", "url1", "", Long.valueOf(0L), Long.valueOf(0L), "", "", "description1", false, true, false, true, false, new String[]{""});
        Mockito.when((Object)this.applicationCenterService.findApplication(1L)).thenReturn((Object)application);
        response = applicationCenterREST.logClickOneApplications(Long.valueOf(1L));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = applicationCenterREST.logOpenDrawer();
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGeneralSettings() throws Exception {
        GeneralSettings generalSettings = new GeneralSettings();
        generalSettings.setMaxFavoriteApps(12L);
        ApplicationCenterREST applicationCenterREST = new ApplicationCenterREST(this.applicationCenterService, this.portalContainer);
        Mockito.when((Object)this.applicationCenterService.getAppGeneralSettings()).thenReturn((Object)generalSettings);
        Response response = applicationCenterREST.getAppGeneralSettings();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)generalSettings.getMaxFavoriteApps(), (long)((GeneralSettings)response.getEntity()).getMaxFavoriteApps());
    }
}

