/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ThreadLocalRandom;

public class BackoffTimer {
    private int numRetries = 0;
    private Duration backoff = backoffInitial;
    private final Duration minTimeout;
    private Instant deadline;
    private static final Duration backoffInitial = Duration.ofSeconds(1L);
    private static final Duration backoffMax = Duration.ofSeconds(120L);
    private static final float jitter = 0.23f;
    private static final float multiplier = 1.6f;

    public BackoffTimer(Duration minTimeout) {
        this.minTimeout = minTimeout;
        this.deadline = Instant.now().plus(this.backoff);
    }

    public Duration getTimeout() {
        Duration timeToDeadline = this.getTimeUntilDeadline();
        if (timeToDeadline.compareTo(this.minTimeout) < 0) {
            return this.minTimeout;
        }
        return timeToDeadline;
    }

    public long getTimeoutMillis() {
        return this.getTimeout().toMillis();
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void sleepUntilRetry() throws InterruptedException {
        try {
            Thread.sleep(this.getTimeUntilDeadline().toMillis());
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw exception;
        }
        this.backoff = Duration.ofNanos((long)((float)this.backoff.toNanos() * 1.6f));
        if (this.backoff.compareTo(backoffMax) > 0) {
            this.backoff = backoffMax;
        }
        float randomJitter = (ThreadLocalRandom.current().nextFloat() * 2.0f - 1.0f) * 0.23f + 1.0f;
        Duration jitteredBackoff = Duration.ofNanos((long)((float)this.backoff.toNanos() * randomJitter));
        this.deadline = Instant.now().plus(jitteredBackoff);
        ++this.numRetries;
    }

    private Duration getTimeUntilDeadline() {
        Instant currentTime = Instant.now();
        if (currentTime.isAfter(this.deadline)) {
            return Duration.ZERO;
        }
        return Duration.between(currentTime, this.deadline);
    }
}

