/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.impl.connectors;

import com.deepl.api.DeepLException;
import com.deepl.api.SentenceSplittingMode;
import com.deepl.api.TextResult;
import com.deepl.api.TextTranslationOptions;
import com.deepl.api.Translator;
import java.lang.reflect.Field;
import java.util.Locale;
import org.exoplatform.automatic.translation.impl.connectors.DeepLTranslateConnector;
import org.exoplatform.commons.api.settings.SettingService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeepLTranslateConnectorTest {
    @Mock
    private SettingService settingService;
    @Mock
    private Translator translator;
    private DeepLTranslateConnector deepLTranslateConnector;

    @Before
    public void setUp() {
        this.deepLTranslateConnector = new DeepLTranslateConnector(this.settingService);
    }

    @Test
    public void translate() throws NoSuchFieldException, IllegalAccessException, DeepLException, InterruptedException {
        TextTranslationOptions textTranslationOptions = new TextTranslationOptions();
        textTranslationOptions.setTagHandling("html");
        textTranslationOptions.setSentenceSplittingMode(SentenceSplittingMode.All);
        TextResult textResult = new TextResult("<h1>Hello</h1>", "fr");
        Field textTranslationOptionsField = this.deepLTranslateConnector.getClass().getDeclaredField("textTranslationOptions");
        textTranslationOptionsField.setAccessible(true);
        textTranslationOptionsField.set(this.deepLTranslateConnector, textTranslationOptions);
        Mockito.when((Object)this.translator.translateText("<h1>Bonjour</h1>", null, "en-US", textTranslationOptions)).thenReturn((Object)textResult);
        Field field = this.deepLTranslateConnector.getClass().getDeclaredField("translator");
        field.setAccessible(true);
        field.set(this.deepLTranslateConnector, this.translator);
        String text = this.deepLTranslateConnector.translate("<h1>Bonjour</h1>", new Locale("en"));
        Assert.assertNotNull((Object)text);
        Mockito.when((Object)this.translator.translateText("<h1>Bonjour</h1>", null, "en-US", textTranslationOptions)).thenThrow(new Throwable[]{new DeepLException("error")});
        text = this.deepLTranslateConnector.translate("<h1>Bonjour</h1>", new Locale("en"));
        Assert.assertNull((Object)text);
    }
}

