/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

import java.util.UUID;
import org.exoplatform.brandadvocacy.model.NoteType;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;

public class MissionParticipantNote {
    private String id;
    private String missionParticipantId;
    private NoteType type;
    private String author;
    private String content;
    private String labelID;

    public MissionParticipantNote() {
    }

    public MissionParticipantNote(String missionParticipantId) {
        this.setLabelID(UUID.randomUUID().toString());
        this.setMissionParticipantId(missionParticipantId);
        this.setType(NoteType.AdminComment);
    }

    public String getMissionParticipantId() {
        return this.missionParticipantId;
    }

    public void setMissionParticipantId(String missionParticipantId) {
        this.missionParticipantId = missionParticipantId;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void checkValid() throws BrandAdvocacyServiceException {
        if (null == this.getMissionParticipantId() || "".equals(this.getMissionParticipantId())) {
            throw new BrandAdvocacyServiceException(8, "mission participant note must have mp id");
        }
        if (null == this.getContent() || "".equals(this.getContent())) {
            throw new BrandAdvocacyServiceException(15, "mp note must have message");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabelID() {
        return this.labelID;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public NoteType getType() {
        return this.type;
    }

    public void setType(NoteType type) {
        this.type = type;
    }
}

