/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.brandadvocacy.model.MissionParticipant;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="brandadv/")
public class RestUpgrade
implements ResourceContainer {
    private Log log = ExoLogger.getLogger(this.getClass());
    private IService iService;
    private static final String[] childNodePaths = new String[0];
    protected static final CacheControl cacheControl_;

    public RestUpgrade(IService iService) {
        this.iService = iService;
    }

    @GET
    @Path(value="/upgrade/nodetype/{name}/{children}")
    @RolesAllowed(value={"administrators"})
    public Response upgradeNodeTypeChild(@PathParam(value="name") String nodeTypeName, @PathParam(value="children") String childNode) {
        String result = "upgrade node type successfully";
        try {
            this.log.info((Object)("==== start upgrade brand adv node type " + nodeTypeName));
            ExtendedNodeTypeManager nodeTypeManager = CommonsUtils.getRepository().getNodeTypeManager();
            NodeTypeValue nodeTypeValue = nodeTypeManager.getNodeTypeValue(nodeTypeName);
            List childValues = nodeTypeValue.getDeclaredChildNodeDefinitionValues();
            if (childValues.size() == 0) {
                this.log.info((Object)("==== add child node " + childNode + " to node type " + nodeTypeName));
                ArrayList<NodeDefinitionValue> nodeDefinitionValues = new ArrayList<NodeDefinitionValue>();
                NodeDefinitionValue noteslist = new NodeDefinitionValue();
                noteslist.setName(childNode);
                ArrayList<String> requiredPrimaryTypes = new ArrayList<String>();
                requiredPrimaryTypes.add("brad:noteslist");
                noteslist.setRequiredNodeTypeNames(requiredPrimaryTypes);
                noteslist.setDefaultNodeTypeName("brad:noteslist");
                noteslist.setOnVersion(1);
                noteslist.setSameNameSiblings(false);
                noteslist.setMandatory(false);
                noteslist.setAutoCreate(true);
                nodeDefinitionValues.add(noteslist);
                nodeTypeValue.setDeclaredChildNodeDefinitionValues(nodeDefinitionValues);
            }
            nodeTypeManager.registerNodeType(nodeTypeValue, 4);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when migrating exo:actionable node type", (Throwable)e);
            }
            result = "upgrade node type unsuccessful";
        }
        return Response.ok((Object)result, (String)"text/html").cacheControl(cacheControl_).build();
    }

    @GET
    @Path(value="/upgrade/nodetype/{name}/{property}/{type}")
    @RolesAllowed(value={"administrators"})
    public Response upgradeNodeTypeProperty(@PathParam(value="name") String nodeTypeName, @PathParam(value="property") String propertyName, @PathParam(value="type") String type) {
        String result;
        block3: {
            result = "upgrade node type successfully";
            this.log.info((Object)("==== start upgrade brand adv node type " + nodeTypeName));
            try {
                ExtendedNodeTypeManager nodeTypeManager = CommonsUtils.getRepository().getNodeTypeManager();
                NodeTypeValue nodeTypeValue = nodeTypeManager.getNodeTypeValue(nodeTypeName);
                List propValues = nodeTypeValue.getDeclaredPropertyDefinitionValues();
                for (PropertyDefinitionValue propValue : propValues) {
                    if (!propertyName.equalsIgnoreCase(propValue.getName())) continue;
                    this.log.info((Object)("==== update property " + propertyName + " set to type " + type));
                    if (type != "long") break;
                    propValue.setRequiredType(3);
                    break;
                }
                nodeTypeValue.setDeclaredPropertyDefinitionValues(propValues);
                nodeTypeManager.registerNodeType(nodeTypeValue, 4);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)"An unexpected error occurs when migrating exo:actionable node type", (Throwable)e);
            }
        }
        return Response.ok((Object)result, (String)"text/html").cacheControl(cacheControl_).build();
    }

    @GET
    @Path(value="/upgrade/childnode/data")
    @RolesAllowed(value={"administrators"})
    public Response upgradeChildnodeData() {
        String result = "upgrade child node for data successfully";
        List<Program> programs = this.iService.getAllPrograms();
        for (Program program : programs) {
            List<MissionParticipant> missionParticipants = this.iService.getAllMissionParticipantsInProgram(program.getId());
            for (MissionParticipant missionParticipant : missionParticipants) {
                if (this.iService.initMPHomeNote(missionParticipant.getId()).booleanValue()) continue;
                result = "upgrade child node for data unsuccessfully";
            }
        }
        return Response.ok((Object)result, (String)"text/html").cacheControl(cacheControl_).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl_ = new CacheControl();
        cacheControl_.setNoCache(true);
        cacheControl_.setNoStore(true);
    }
}

