/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

import java.util.UUID;
import org.exoplatform.brandadvocacy.model.Size;
import org.exoplatform.brandadvocacy.model.Status;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;

public class MissionParticipant {
    private String id;
    private String mission_id;
    private String proposition_id;
    private String participant_username;
    private String address_id;
    private String url_submitted;
    private Status status;
    private long date_submitted;
    private long createdDate;
    private long modifiedDate;
    private Size size;
    private String labelID;

    public MissionParticipant() {
        this.setLabelID(UUID.randomUUID().toString());
        this.setStatus(Status.OPEN);
        this.setSize(Size.Medium);
        this.setCreatedDate(System.currentTimeMillis());
        this.setModifiedDate(System.currentTimeMillis());
    }

    public String getLabelID() {
        return this.labelID;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public String getId() {
        return this.id;
    }

    public String getMission_id() {
        return this.mission_id;
    }

    public void setMission_id(String mission_id) {
        this.mission_id = mission_id;
    }

    public String getProposition_id() {
        return this.proposition_id;
    }

    public void setProposition_id(String proposition_id) {
        this.proposition_id = proposition_id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParticipant_username() {
        return this.participant_username;
    }

    public void setParticipant_username(String participant_username) {
        this.participant_username = participant_username;
    }

    public String getUrl_submitted() {
        if (null != this.url_submitted && !"".equals(this.url_submitted)) {
            return this.url_submitted;
        }
        return "not provided yet";
    }

    public void setUrl_submitted(String url_submitted) {
        this.url_submitted = url_submitted;
    }

    public String getAddress_id() {
        return this.address_id;
    }

    public void setAddress_id(String address_id) {
        this.address_id = address_id;
    }

    public long getDate_submitted() {
        return this.date_submitted;
    }

    public void setDate_submitted(long date_submitted) {
        this.date_submitted = date_submitted;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(long modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public void checkValid() throws BrandAdvocacyServiceException {
        if (null == this.getLabelID() || "".equals(this.getLabelID())) {
            throw new BrandAdvocacyServiceException(8, "mission participant must have label ID");
        }
        if (null == this.getParticipant_username() || "".equals(this.getParticipant_username())) {
            throw new BrandAdvocacyServiceException(9, "mission participant must be assigned to a participant");
        }
        if (null == this.getMission_id() || "".equals(this.getMission_id())) {
            throw new BrandAdvocacyServiceException(9, "mission participant must belong to a mission");
        }
    }

    public String toString() {
        return this.getClass().getName() + " - username = " + this.getParticipant_username() + " - id = " + this.getId() + " - missionid= " + this.getMission_id() + " propoid= " + this.getProposition_id();
    }
}

