/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.model;

import java.util.UUID;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;

public class Proposition {
    private String id;
    private String mission_id;
    private String content;
    private Boolean active;
    private int numberUsed;
    private String labelID;

    public Proposition() {
        this.init();
    }

    public Proposition(String content) {
        this.setContent(content);
        this.init();
    }

    private void init() {
        this.setLabelID(UUID.randomUUID().toString());
        this.setNumberUsed(0);
        this.setActive(false);
    }

    public String getLabelID() {
        return this.labelID;
    }

    public void setLabelID(String labelID) {
        this.labelID = labelID;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMission_id() {
        return this.mission_id;
    }

    public void setMission_id(String mission_id) {
        this.mission_id = mission_id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public int getNumberUsed() {
        return this.numberUsed;
    }

    public void setNumberUsed(int nb) {
        this.numberUsed = nb;
    }

    public void checkValid() throws BrandAdvocacyServiceException {
        if (null == this.getContent() || "".equals(this.getContent())) {
            throw new BrandAdvocacyServiceException(7, "proposition cannot have empty content");
        }
        if (null == this.getMission_id() || "".equals(this.getMission_id())) {
            throw new BrandAdvocacyServiceException(7, "proposition must belogn to 1 mission");
        }
    }

    public String getShortContent(int length) {
        int maxLeng = this.getContent().length();
        if (maxLeng < length) {
            return this.getContent();
        }
        return this.getContent().substring(0, length) + " ... ";
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.getId() + " - mission id = " + this.getMission_id() + " - content= " + this.getContent();
    }
}

