/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.jcr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.brandadvocacy.jcr.DAO;
import org.exoplatform.brandadvocacy.model.Proposition;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;
import org.exoplatform.brandadvocacy.service.JCRImpl;
import org.exoplatform.brandadvocacy.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PropositionDAO
extends DAO {
    private static final String node_prop_labelID = "exo:labelID";
    public static final String node_prop_mission_id = "exo:mission_id";
    public static final String node_prop_content = "exo:content";
    public static final String node_prop_active = "exo:active";
    public static final String node_prop_numberUsed = "exo:numberUsed";
    private static final Log log = ExoLogger.getLogger(PropositionDAO.class);

    public PropositionDAO(JCRImpl jcrImpl) {
        super(jcrImpl);
    }

    private Node getOrCreatePropositionHome(String missionId) {
        if (null == missionId || "".equals(missionId)) {
            log.error((Object)"ERROR cannot get mission home for an invalid program id ");
            return null;
        }
        try {
            return this.getJcrImplService().getMissionDAO().getOrCreatePropositionHome(this.getNodeById(missionId));
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setProperties(Node aNode, Proposition p) throws RepositoryException {
        aNode.setProperty(node_prop_labelID, p.getLabelID());
        aNode.setProperty(node_prop_mission_id, p.getMission_id());
        aNode.setProperty(node_prop_content, p.getContent());
        aNode.setProperty(node_prop_active, p.getActive().booleanValue());
        aNode.setProperty(node_prop_numberUsed, (long)p.getNumberUsed());
    }

    private Proposition transferNode2Object(Node node) throws RepositoryException {
        if (null == node) {
            return null;
        }
        Proposition proposition = new Proposition();
        proposition.setId(node.getUUID());
        PropertyIterator iter = node.getProperties("exo:*");
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            String name = p.getName();
            if (name.equals(node_prop_labelID)) {
                proposition.setLabelID(p.getString());
                continue;
            }
            if (name.equals(node_prop_mission_id)) {
                proposition.setMission_id(p.getString());
                continue;
            }
            if (name.equals(node_prop_content)) {
                proposition.setContent(p.getString());
                continue;
            }
            if (name.equals(node_prop_active)) {
                proposition.setActive(p.getBoolean());
                continue;
            }
            if (!name.equals(node_prop_numberUsed)) continue;
            proposition.setNumberUsed((int)p.getLong());
        }
        try {
            proposition.checkValid();
            return proposition;
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR transfer node to proposition object " + brade.getMessage()));
            return null;
        }
    }

    private List<Proposition> transferNodes2Objects(List<Node> nodes, Boolean isActive) {
        ArrayList<Proposition> propositions = new ArrayList<Proposition>(nodes.size());
        for (Node node : nodes) {
            try {
                Proposition aPropostion = this.transferNode2Object(node);
                if (null == aPropostion) continue;
                if (null == isActive) {
                    propositions.add(aPropostion);
                    continue;
                }
                if (aPropostion.getActive() != isActive) continue;
                propositions.add(aPropostion);
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return propositions;
    }

    private Node getNodeByLabelID(String mid, String pid) {
        StringBuilder sql = new StringBuilder("select * from brad:proposition where jcr:path like '");
        sql.append("/BrandAdvocacys").append("/").append("Missions");
        sql.append("/").append(Utils.queryEscape(mid)).append("/").append("exo:propositionslist");
        sql.append("/").append(Utils.queryEscape(pid));
        sql.append("'");
        try {
            Session session = this.getJcrImplService().getSession();
            Query query = session.getWorkspace().getQueryManager().createQuery(sql.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            if (nodes.hasNext()) {
                return nodes.nextNode();
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("ERROR cannot get proposition  " + pid + " from mission " + mid + " Exeption " + e.getMessage()));
        }
        return null;
    }

    public List<Proposition> searchPropositions(String keyword, int offset, int limit) {
        StringBuilder sql = new StringBuilder("select * from brad:proposition where ");
        sql.append(node_prop_labelID).append(" like '%" + keyword + "%'");
        sql.append(" OR exo:content").append(" like '%" + keyword + "%'");
        List<Node> nodes = this.getNodesByQuery(sql.toString(), offset, limit);
        return this.transferNodes2Objects(nodes, null);
    }

    public Proposition addProposition2Mission(Proposition proposition) {
        try {
            proposition.checkValid();
            String mid = proposition.getMission_id();
            Node propositionHomeNode = this.getOrCreatePropositionHome(mid);
            if (null != propositionHomeNode) {
                Node node = propositionHomeNode.addNode(proposition.getLabelID(), "brad:proposition");
                this.setProperties(node, proposition);
                propositionHomeNode.save();
                return this.transferNode2Object(node);
            }
        }
        catch (ItemExistsException ie) {
            log.error((Object)(" === ERROR cannot add existing item " + ie.getMessage()));
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.error((Object)("=== ERROR cannot add proposition to mission " + e.getMessage()));
        }
        catch (RepositoryException e) {
            log.error((Object)("=== ERROR cannot add proposition to mission " + e.getMessage()));
        }
        return null;
    }

    public List<Proposition> getAllPropositions(String mid, Boolean isActive) {
        try {
            Node propositionHomeNode = this.getOrCreatePropositionHome(mid);
            if (null != propositionHomeNode) {
                NodeIterator nodes = propositionHomeNode.getNodes();
                return this.transferNodes2Objects(Lists.newArrayList((Iterator)nodes), isActive);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR get all propositions " + e.getMessage()));
        }
        return null;
    }

    public Proposition updateProposition(Proposition proposition) {
        try {
            proposition.checkValid();
            Node propositionNode = this.getNodeById(proposition.getId());
            if (null != propositionNode) {
                this.setProperties(propositionNode, proposition);
                propositionNode.save();
                return this.transferNode2Object(propositionNode);
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot update proposition " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)brade.getMessage());
        }
        return null;
    }

    public Boolean removeProposition(String id) {
        try {
            Node propositionNode = this.getNodeById(id);
            if (null != propositionNode) {
                Session session = propositionNode.getSession();
                propositionNode.remove();
                session.save();
                return true;
            }
            throw new BrandAdvocacyServiceException(11, " cannot remove proposition not exists");
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR cannot remove proposition " + e.getMessage()));
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)brade.getMessage());
        }
        return false;
    }

    public Proposition getPropositionById(String id) {
        try {
            return this.transferNode2Object(this.getNodeById(id));
        }
        catch (RepositoryException e) {
            log.error((Object)" cannot get proposition ");
            return null;
        }
    }

    public int getTotalNumberPropositions(Boolean isPublic, Boolean isActive, String mid) {
        StringBuilder sql = new StringBuilder("select jcr:uuid from brad:proposition where ");
        if (isPublic.booleanValue()) {
            sql.append(node_prop_active).append("= 'true' ");
        } else {
            sql.append(node_prop_active).append("='").append(isActive).append("'");
        }
        if (null != mid && !"".equals(mid)) {
            sql.append(" AND ").append(node_prop_mission_id).append(" = ").append(mid);
        }
        return this.getNodesByQuery(sql.toString(), 0, 0).size();
    }

    public Proposition getRandomProposition(String mid) {
        StringBuilder sql = new StringBuilder("select * from brad:proposition where ");
        sql.append(node_prop_active).append("= 'true'");
        sql.append(" AND ").append(node_prop_mission_id).append("='").append(mid).append("'");
        sql.append(" ORDER BY ").append(node_prop_numberUsed).append(" ASC ");
        List<Node> nodes = this.getNodesByQuery(sql.toString(), 0, 1);
        try {
            if (nodes.size() > 0) {
                return this.transferNode2Object(nodes.get(0));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"ERROR cannot get random proposition");
        }
        return null;
    }
}

