/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.brandadvocacy.jcr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.brandadvocacy.jcr.DAO;
import org.exoplatform.brandadvocacy.model.Participant;
import org.exoplatform.brandadvocacy.service.BrandAdvocacyServiceException;
import org.exoplatform.brandadvocacy.service.JCRImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ParticipantDAO
extends DAO {
    private static final String node_prop_program_id = "exo:program_id";
    private static final String node_prop_username = "exo:username";
    private static final String node_prop_mission_participant_ids = "exo:mission_participant_ids";
    private static final String node_prop_mission_ids = "exo:mission_ids";
    public static final String node_prop_addresses = "exo:addresseslist";
    private static final Log log = ExoLogger.getLogger(ParticipantDAO.class);

    public ParticipantDAO(JCRImpl jcrImpl) {
        super(jcrImpl);
    }

    private void setProperties(Node aNode, Participant participant) throws RepositoryException {
        try {
            participant.checkValid();
            Set<String> missionParticipantIds = participant.getMission_participant_ids();
            Set<String> missionIds = participant.getMission_ids();
            aNode.setProperty(node_prop_program_id, participant.getProgramId());
            aNode.setProperty(node_prop_mission_participant_ids, missionParticipantIds.toArray(new String[missionParticipantIds.size()]));
            aNode.setProperty(node_prop_mission_ids, missionIds.toArray(new String[missionIds.size()]));
            aNode.setProperty(node_prop_username, participant.getUserName());
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR cannot set peroperties for participant node " + brade.getMessage()));
        }
    }

    public Participant transferNode2Object(Node node) throws RepositoryException {
        if (null == node) {
            return null;
        }
        Participant participant = new Participant();
        PropertyIterator iter = node.getProperties("exo:*");
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            String name = p.getName();
            if (name.equals(node_prop_mission_participant_ids)) {
                HashSet<String> missionParticipantIds = new HashSet<String>();
                for (Value mpid : p.getValues()) {
                    missionParticipantIds.add(mpid.getString());
                }
                participant.setMission_participant_ids(missionParticipantIds);
                continue;
            }
            if (name.equals(node_prop_mission_ids)) {
                HashSet<String> missionIds = new HashSet<String>();
                for (Value mids : p.getValues()) {
                    missionIds.add(mids.getString());
                }
                participant.setMission_ids(missionIds);
                continue;
            }
            if (name.equals(node_prop_username)) {
                participant.setUserName(p.getString());
                continue;
            }
            if (!name.equals(node_prop_program_id)) continue;
            participant.setProgramId(p.getString());
        }
        try {
            participant.checkValid();
            return participant;
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)("ERROR cannot transfert node to participant obj " + brade.getMessage()));
            return null;
        }
    }

    private Node getOrCreateParticipantHome(String programId) {
        if (null == programId || "".equals(programId)) {
            log.error((Object)"ERROR cannot get or create participant home in program null");
            return null;
        }
        Node programNode = null;
        try {
            programNode = this.getNodeById(programId);
            if (null != programNode) {
                return this.getJcrImplService().getProgramDAO().getOrCreateParticipantHome(programNode);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    public Node getOrCreateAddressHome(Node participantNode) {
        try {
            return this.getOrCreateNodeCommon(participantNode, node_prop_addresses, "brad:addresseslist");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Node getNodeByUserName(String programId, String username) {
        if (!StringUtils.isNotEmpty((String)programId) || null == programId || null == username || !StringUtils.isNotEmpty((String)username)) {
            return null;
        }
        Node programNode = null;
        try {
            programNode = this.getJcrImplService().getProgramDAO().getNodeById(programId);
            if (null != programNode) {
                Node homeNode = this.getJcrImplService().getProgramDAO().getOrCreateParticipantHome(programNode);
                if (null != username && null != homeNode && homeNode.hasNode(username)) {
                    return homeNode.getNode(username);
                }
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Node getNodeByQuery(String programId, String username) {
        StringBuilder sql = new StringBuilder("select * from brad:participant");
        sql.append(" WHERE ").append(" jcr:path like '/").append("/BrandAdvocacys").append("/").append(programId);
        sql.append("/").append("exo:participantslist").append("/%'");
        sql.append(" AND ").append(node_prop_username).append(" like '").append(username).append("'");
        sql.append(" AND ").append(node_prop_program_id).append(" = '").append(programId).append("'");
        List<Node> nodes = this.getNodesByQuery(sql.toString(), 0, 1);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    public Participant addParticipant2Program(Participant participant) {
        try {
            participant.checkValid();
            String programId = participant.getProgramId();
            Node participantHomeNode = this.getOrCreateParticipantHome(programId);
            if (null != participantHomeNode) {
                Node participantNode = null;
                if (participantHomeNode.hasNode(participant.getUserName())) {
                    participantNode = participantHomeNode.getNode(participant.getUserName());
                    Participant existingParticipant = this.transferNode2Object(participantNode);
                    Set<String> newMPIds = participant.getMission_participant_ids();
                    for (String mpid : existingParticipant.getMission_participant_ids()) {
                        if (newMPIds.contains(mpid)) continue;
                        newMPIds.add(mpid);
                    }
                    participant.setMission_participant_ids(newMPIds);
                    Set<String> newMIds = participant.getMission_ids();
                    for (String mid : existingParticipant.getMission_ids()) {
                        if (newMIds.contains(mid)) continue;
                        newMIds.add(mid);
                    }
                    participant.setMission_ids(newMIds);
                } else {
                    participantNode = participantHomeNode.addNode(participant.getUserName(), "brad:participant");
                }
                if (null != participantNode) {
                    this.setProperties(participantNode, participant);
                    participantHomeNode.getSession().save();
                    return participant;
                }
            }
        }
        catch (ItemExistsException ie) {
            log.error((Object)("=== ERROR cannot add existing participant " + participant.getUserName() + " - exception " + ie.getMessage()));
        }
        catch (RepositoryException re) {
            log.error((Object)(" === ERROR cannot add participant " + participant.getUserName() + " - exception "));
            re.printStackTrace();
        }
        catch (BrandAdvocacyServiceException brade) {
            log.error((Object)(" === ERROR add participant " + brade.getMessage()));
        }
        return null;
    }

    public List<Participant> getAllParticipantsInProgram(String programId) {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        try {
            Node participantHomeNode = this.getOrCreateParticipantHome(programId);
            if (null != participantHomeNode) {
                NodeIterator nodes = participantHomeNode.getNodes();
                Node participantNode = null;
                Participant participant = null;
                while (nodes.hasNext()) {
                    participantNode = (Node)nodes.next();
                    participant = this.transferNode2Object(participantNode);
                    if (null == participant) continue;
                    participants.add(participant);
                }
                return participants;
            }
            throw new BrandAdvocacyServiceException(3, "cannot find participant home node");
        }
        catch (RepositoryException e) {
            log.error((Object)("==== ERROR get all participants " + e.getMessage()));
            return participants;
        }
    }

    public Participant getParticipantInProgramByUserName(String programId, String username) {
        try {
            return this.transferNode2Object(this.getNodeByUserName(programId, username));
        }
        catch (RepositoryException e) {
            log.error((Object)"ERROR cannot get participant by username");
            return null;
        }
    }

    public Boolean removeMissionParticipant(String programId, String userName, String missionParticipantId) {
        Node participantNode = this.getNodeByUserName(programId, userName);
        if (null != participantNode) {
            try {
                Set<String> mpIds;
                Participant participant = this.transferNode2Object(participantNode);
                if (null != participant && (mpIds = participant.getMission_participant_ids()).contains(missionParticipantId) && mpIds.remove(missionParticipantId)) {
                    participant.setMission_participant_ids(mpIds);
                    this.setProperties(participantNode, participant);
                    participantNode.save();
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.error((Object)("Error remove mission participant " + e.getMessage()));
            }
        }
        return false;
    }

    public Boolean removeMission(String programId, String userName, String missionId) {
        Node participantNode = this.getNodeByUserName(programId, userName);
        if (null != participantNode) {
            try {
                Set<String> mIds;
                Participant participant = this.transferNode2Object(participantNode);
                if (null != participant && (mIds = participant.getMission_ids()).contains(missionId) && mIds.remove(missionId)) {
                    participant.setMission_ids(mIds);
                    this.setProperties(participantNode, participant);
                    participantNode.save();
                    return true;
                }
            }
            catch (RepositoryException e) {
                log.error((Object)("Error remove mission participant " + e.getMessage()));
            }
        }
        return false;
    }
}

