/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend.controllers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.model.Role;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.LoginController;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.ManagerDTO;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.manager.list;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.manager.search;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Profile;

@SessionScoped
public class ManagerController {
    IService jcrService;
    OrganizationService organizationService;
    @Inject
    LoginController loginController;
    @Inject
    @Path(value="manager/list.gtmpl")
    list listTpl;
    @Inject
    @Path(value="manager/search.gtmpl")
    search searchTpl;

    @Inject
    public ManagerController(OrganizationService organizationService, IService iService) {
        this.organizationService = organizationService;
        this.jcrService = iService;
    }

    @Ajax
    @Resource
    public Response listProgramManagers() {
        String programId = this.loginController.getCurrentProgramId();
        if (null != programId) {
            List managers = this.jcrService.getAllManagersInProgram(programId);
            ArrayList<ManagerDTO> managerDTOs = new ArrayList<ManagerDTO>(managers.size());
            for (Manager manager : managers) {
                try {
                    User exoUser = this.organizationService.getUserHandler().findUserByName(manager.getUserName());
                    if (null == exoUser) continue;
                    ManagerDTO managerDTO = new ManagerDTO(manager.getUserName());
                    managerDTO.setFullName(exoUser.getFirstName() + " " + exoUser.getLastName());
                    managerDTO.setRole(manager.getRole());
                    managerDTO.setNotif(manager.getNotif().booleanValue());
                    managerDTOs.add(managerDTO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.listTpl.with().set("roles", (Object)Role.values()).set("managers", managerDTOs).set("currentUser", (Object)this.loginController.getCurrentUserName()).ok();
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response add2Program(String username, String role, String notif) {
        block6: {
            try {
                String progamId = this.loginController.getCurrentProgramId();
                User exoUser = this.organizationService.getUserHandler().findUserByName(username);
                if (null != exoUser) {
                    Program program;
                    Boolean mNotif = false;
                    if (null != notif) {
                        mNotif = "true".equals(notif);
                    }
                    if (null != (program = this.jcrService.getProgramById(progamId))) {
                        Manager manager = new Manager(username);
                        manager.setParentId(program.getId());
                        manager.setRole(Role.getRole((int)Integer.parseInt(role)));
                        manager.setNotif(mNotif);
                        manager = this.jcrService.addManager2Program(manager);
                        if (null != manager) {
                            return Response.ok((CharSequence)"ok");
                        }
                    }
                    break block6;
                }
                return Response.ok((CharSequence)"cannot find this user");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Response.ok((CharSequence)"something went wrong, cannot add user like a manager");
    }

    @Ajax
    @Resource
    public Response addManagers2Program(String[] usernames, String role, String notif) {
        try {
            String progamId = this.loginController.getCurrentProgramId();
            if (null == progamId || null == usernames || usernames.length <= 0) {
                return Response.ok((CharSequence)"something went wrong, cannot add user like a manager");
            }
            Boolean mNotif = false;
            mNotif = false;
            if (null != notif) {
                mNotif = "true".equals(notif);
            }
            ArrayList<Manager> managers = new ArrayList<Manager>();
            for (String username : usernames) {
                try {
                    User exoUser = this.organizationService.getUserHandler().findUserByName(username);
                    if (null == exoUser) continue;
                    Manager manager = new Manager(username);
                    manager.setParentId(progamId);
                    manager.setRole(Role.getRole((int)Integer.parseInt(role)));
                    manager.setNotif(mNotif);
                    manager.checkValid();
                    managers.add(manager);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (managers.size() > 0 && this.jcrService.addManagers2Program(progamId, managers).size() > 0) {
                return Response.ok((CharSequence)"ok");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.ok((CharSequence)"something went wrong, cannot add user like a manager");
    }

    @Ajax
    @Resource
    public Response updateAjaxProgramManagerInLine(String username, String action, String val) {
        String programId = this.loginController.getCurrentProgramId();
        Manager manager = this.jcrService.getProgramManagerByUserName(programId, username);
        if (null != manager) {
            if (action.equals("notif")) {
                Boolean mNotif = false;
                mNotif = "true".equals(val);
                manager.setNotif(mNotif);
            } else if (action.equals("role")) {
                manager.setRole(Role.getRole((int)Integer.parseInt(val)));
            }
            manager = this.jcrService.updateProgramManager(manager);
            if (null != manager) {
                if (manager.getUserName().equals(this.loginController.getCurrentUserName())) {
                    this.loginController.setRights(manager.getRole().getLabel());
                }
                return Response.ok((CharSequence)"ok");
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response removeProgramManager(String username) {
        String programId = this.loginController.getCurrentProgramId();
        if (this.jcrService.removeManagerFromProgram(programId, username).booleanValue()) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response searchEXOUsers(String keyword) {
        ListAccess userListAccess = this.jcrService.searchEXOUsers(keyword);
        if (null != userListAccess) {
            LinkedList<ManagerDTO> managerDTOs = new LinkedList<ManagerDTO>();
            try {
                for (int i = 0; i < userListAccess.getSize(); ++i) {
                    try {
                        User[] users = (User[])userListAccess.load(i, 1);
                        User user = users[0];
                        if (null == user) continue;
                        ManagerDTO managerDTO = new ManagerDTO(user.getUserName());
                        managerDTO.setUserName(user.getUserName());
                        managerDTO.setFullName(user.getFirstName() + " " + user.getLastName());
                        managerDTOs.add(managerDTO);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (managerDTOs.size() > 0) {
                    return this.searchTpl.with().set("managers", managerDTOs).ok();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Response.ok((CharSequence)"");
    }

    @Ajax
    @Resource
    public Response searchEXOProfiles(String keyword) {
        List profiles = this.jcrService.searchEXOProfiles(keyword);
        if (null != profiles) {
            LinkedList<ManagerDTO> managerDTOs = new LinkedList<ManagerDTO>();
            try {
                for (int i = 0; i < profiles.size(); ++i) {
                    try {
                        Profile profile = (Profile)profiles.get(i);
                        if (null == profile) continue;
                        ManagerDTO managerDTO = new ManagerDTO(profile.getIdentity().getRemoteId());
                        managerDTO.setFullName(profile.getFullName());
                        managerDTOs.add(managerDTO);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (managerDTOs.size() > 0) {
                    return this.searchTpl.with().set("managers", managerDTOs).ok();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Response.ok((CharSequence)"user not found");
    }
}

