/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend.controllers;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import org.exoplatform.brandadvocacy.model.Mission;
import org.exoplatform.brandadvocacy.model.Priority;
import org.exoplatform.brandadvocacy.model.Query;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.LoginController;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.MissionDTO;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission.add;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission.edit;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission.index;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission.list;
import org.json.JSONException;
import org.json.JSONObject;

@SessionScoped
public class MissionController {
    IService missionService;
    @Inject
    LoginController loginController;
    @Inject
    @Path(value="mission/index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="mission/add.gtmpl")
    add addTpl;
    @Inject
    @Path(value="mission/edit.gtmpl")
    edit editTpl;
    @Inject
    @Path(value="mission/list.gtmpl")
    list listTpl;

    @Inject
    public MissionController(IService missionService) {
        this.missionService = missionService;
    }

    @Ajax
    @Resource
    public Response indexMission() {
        if (null != this.loginController.getCurrentProgramId()) {
            return this.list("", null, null);
        }
        return Response.ok((CharSequence)"There is no program yet");
    }

    @Ajax
    @Resource
    public Response addForm() {
        return this.addTpl.with().ok();
    }

    @Ajax
    @Resource
    public Response editForm(String missionId) {
        Mission mission = this.missionService.getMissionById(missionId);
        if (null != mission) {
            MissionDTO missionDTO = new MissionDTO(mission.getProgramId(), mission.getId(), mission.getTitle(), mission.getPriority(), mission.getThird_part_link(), mission.getActive());
            List propositions = this.missionService.getAllPropositions(mission.getId(), null);
            return this.editTpl.with().set("priorities", (Object)Priority.values()).set("mission", (Object)missionDTO).set("propositions", (Object)propositions).ok();
        }
        return Response.ok((CharSequence)"nok");
    }

    public Response list(String keyword, String size, String page) {
        String alertPriority = "";
        String programId = this.loginController.getCurrentProgramId();
        List missions = this.missionService.searchMission(new Query(programId));
        LinkedList<MissionDTO> missionDTOs = new LinkedList<MissionDTO>();
        int totalPriority = 0;
        for (Mission mission : missions) {
            MissionDTO missionDTO = new MissionDTO(mission.getProgramId(), mission.getId(), mission.getTitle(), mission.getPriority(), mission.getThird_part_link(), mission.getActive());
            missionDTO.setPropositions(this.missionService.getAllPropositions(mission.getId(), Boolean.valueOf(true)));
            if (mission.getActive().booleanValue()) {
                totalPriority += (int)mission.getPriority();
            }
            missionDTOs.add(missionDTO);
        }
        return this.listTpl.with().set("priorities", (Object)Priority.values()).set("missions", missionDTOs).set("alertPriority", (Object)alertPriority).set("totalPriority", (Object)totalPriority).ok();
    }

    @Ajax
    @Resource
    public Response addMission(String title, String third_part_link, String priority) {
        Boolean mActive = false;
        Mission mission = new Mission(this.loginController.getCurrentProgramId(), title);
        mission.setThird_part_link(third_part_link);
        mission.setActive(mActive);
        mission.setPriority((long)Integer.parseInt(priority));
        mission = this.missionService.addMission2Program(mission);
        if (null != mission) {
            return Response.ok((CharSequence)mission.getId());
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response updateMission(String id, String title, String third_part_link, String mission_active) {
        Mission mission = this.missionService.getMissionById(id);
        if (null != mission) {
            mission.setTitle(title);
            mission.setThird_part_link(third_part_link);
            mission.setCreatedDate(0L);
            Boolean mActive = false;
            if (null != mission_active) {
                mActive = mission_active.equals("true");
            }
            mission.setActive(mActive);
            mission = this.missionService.updateMission(mission);
            if (null != mission) {
                return Response.ok((CharSequence)"ok");
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response deleteMission(String missionId) {
        if (this.missionService.removeMissionById(missionId).booleanValue()) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response ajaxUpdateInline(String missionId, String action, String val) {
        Boolean error2 = false;
        Mission mission = this.missionService.getMissionById(missionId);
        JSONObject jsonObject = new JSONObject();
        boolean doUpdate = true;
        String errorMsg = "";
        if (null != mission) {
            if (action.equals("priority")) {
                mission.setPriority((long)Integer.parseInt(val));
            } else if (action.equals("active")) {
                Boolean mActive = false;
                mActive = val.equals("true");
                mission.setActive(mActive);
                if (mActive.booleanValue() && this.missionService.getAllPropositions(missionId, Boolean.valueOf(true)).size() == 0) {
                    doUpdate = false;
                }
            }
            if (doUpdate) {
                mission = this.missionService.updateMission(mission);
            } else {
                errorMsg = "You cannot activate this mission, as there is no proposition";
                error2 = true;
            }
        }
        if (null == mission) {
            errorMsg = "Something went wrong, cannot update mission";
            error2 = true;
        }
        try {
            jsonObject.put("error", (Object)error2);
            jsonObject.put("msg", (Object)errorMsg);
            jsonObject.put("mid", (Object)missionId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Response.ok((CharSequence)jsonObject.toString());
    }

    @Ajax
    @Resource
    public Response updateMissionPriority(String missionId, String priority) {
        Mission mission = this.missionService.getMissionById(missionId);
        if (null != mission) {
            int prio = Integer.parseInt(priority);
            if (mission.getPriority() != (long)prio) {
                mission.setPriority((long)prio);
                if (null != this.missionService.updateMission(mission)) {
                    return Response.ok((CharSequence)"Priority has been updated");
                }
                return Response.ok((CharSequence)"Something went wrong, cannot update priority");
            }
            return Response.ok((CharSequence)"Priority has been updated");
        }
        return Response.ok((CharSequence)"Mission no longer exist");
    }
}

