/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend.controllers;

import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import org.exoplatform.brandadvocacy.model.Mission;
import org.exoplatform.brandadvocacy.model.Priority;
import org.exoplatform.brandadvocacy.model.Proposition;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.proposition.add;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.proposition.edit;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.proposition.list;

@SessionScoped
public class PropositionController {
    IService propositionService;
    @Inject
    @Path(value="proposition/add.gtmpl")
    add addTpl;
    @Inject
    @Path(value="proposition/edit.gtmpl")
    edit editTpl;
    @Inject
    @Path(value="proposition/list.gtmpl")
    list listTpl;

    @Inject
    public PropositionController(IService iService) {
        this.propositionService = iService;
    }

    @Ajax
    @Resource
    public Response indexProposition(String missionId) {
        return this.list(missionId);
    }

    @Ajax
    @Resource
    public Response loadAddPropositionForm(String missionId) {
        return this.addTpl.with().set("missionId", (Object)missionId).ok();
    }

    @Ajax
    @Resource
    public Response loadEditPropositionForm(String propositionId) {
        Proposition proposition = this.propositionService.getPropositionById(propositionId);
        if (null != proposition) {
            return this.editTpl.with().proposition((Object)proposition).ok();
        }
        return Response.ok((CharSequence)"cannot find proposition to update");
    }

    public Response list(String mid) {
        Mission mission = this.propositionService.getMissionById(mid);
        if (null != mission) {
            List propositions = this.propositionService.getAllPropositions(mission.getId(), null);
            return this.listTpl.with().set("priorities", (Object)Priority.values()).set("mission", (Object)mission).set("propositions", (Object)propositions).ok();
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response addProposition(String missionId, String content, String active) {
        Mission mission = this.propositionService.getMissionById(missionId);
        if (null != mission) {
            Boolean proposActive = false;
            if (null != active) {
                proposActive = active.equals("true");
            }
            Proposition proposition = new Proposition(content);
            proposition.setMission_id(missionId);
            proposition.setActive(proposActive);
            proposition = this.propositionService.addProposition2Mission(proposition);
            if (null != proposition) {
                return Response.ok((CharSequence)"ok");
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response deleteProposition(String propositionId) {
        if (this.propositionService.removeProposition(propositionId).booleanValue()) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response updateProposition(String propositionId, String content, String active) {
        Proposition proposition = this.propositionService.getPropositionById(propositionId);
        if (null != proposition) {
            Boolean proposActive = false;
            if (null != active) {
                proposActive = active.equals("true");
            }
            proposition.setContent(content);
            proposition.setActive(proposActive);
            proposition = this.propositionService.updateProposition(proposition);
            if (null != proposition) {
                return Response.ok((CharSequence)"ok");
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response ajaxUpdatePropositionInline(String propositionId, String action, String val) {
        Proposition proposition = this.propositionService.getPropositionById(propositionId);
        if (null != proposition) {
            if (action.equals("active")) {
                Boolean proposActive = false;
                proposActive = val.equals("true");
                proposition.setActive(proposActive);
            }
            if (null != (proposition = this.propositionService.updateProposition(proposition))) {
                return Response.ok((CharSequence)val);
            }
        }
        return Response.ok((CharSequence)"nok");
    }
}

