/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend.controllers;

import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.plugin.ajax.Ajax;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.brandadvocacy.service.Utils;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.LoginController;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.program.add;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.program.index;
import org.exoplatform.services.organization.OrganizationService;
import org.json.JSONException;
import org.json.JSONObject;

@SessionScoped
public class ProgramController {
    @Inject
    @Path(value="program/index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="program/add.gtmpl")
    add addTpl;
    OrganizationService organizationService;
    IService jcrService;
    @Inject
    LoginController loginController;

    @Inject
    public ProgramController(OrganizationService organizationService, IService iService) {
        this.organizationService = organizationService;
        this.jcrService = iService;
    }

    @Ajax
    @Resource
    public Response index() {
        String banner_url = "";
        String email_sender = "";
        Program program = null;
        String programId = this.loginController.getCurrentProgramId();
        if (null != programId) {
            program = this.jcrService.getProgramById(programId);
        }
        if (null != program) {
            JSONObject settings = this.jcrService.getProgramSettings(programId);
            if (null != settings) {
                banner_url = Utils.getAttrFromJson((JSONObject)settings, (String)"banner_url");
                email_sender = Utils.getAttrFromJson((JSONObject)settings, (String)"email_sender");
            }
            return this.indexTpl.with().set("program", (Object)program).set("banner_url", (Object)banner_url).set("email_sender", (Object)email_sender).ok();
        }
        return this.addTpl.ok();
    }

    @Ajax
    @Resource
    public Response add(String title) {
        Program program = new Program(title);
        if (null != (program = this.jcrService.addProgram(program))) {
            Manager manager = new Manager(this.loginController.getCurrentUserName());
            manager.setParentId(program.getId());
            if (null != this.jcrService.addManager2Program(manager)) {
                this.loginController.setCurrentProgramId(program.getId());
                return Response.ok((CharSequence)program.getId());
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response update(String title, String banner_url, String email_sender) {
        String programId = this.loginController.getCurrentProgramId();
        Program program = this.jcrService.getProgramById(programId);
        if (null != program) {
            program.setTitle(title);
            if (null != this.jcrService.updateProgram(program)) {
                JSONObject settings = new JSONObject();
                try {
                    if (null == banner_url) {
                        banner_url = "";
                    }
                    if (null == email_sender) {
                        email_sender = "";
                    }
                    settings.put("banner_url", (Object)banner_url);
                    settings.put("email_sender", (Object)email_sender);
                    program.setSettings(settings);
                    this.jcrService.setProgramSettings(program);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return Response.ok((CharSequence)"The program has been updated");
            }
        }
        return Response.ok((CharSequence)"nok");
    }
}

