/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend.controllers;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import org.exoplatform.brandadvocacy.model.Address;
import org.exoplatform.brandadvocacy.model.Mission;
import org.exoplatform.brandadvocacy.model.MissionParticipant;
import org.exoplatform.brandadvocacy.model.MissionParticipantNote;
import org.exoplatform.brandadvocacy.model.NoteType;
import org.exoplatform.brandadvocacy.model.Query;
import org.exoplatform.brandadvocacy.model.Status;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.community.brandadvocacy.portlet.backend.Utils;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.LoginController;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.AddressDTO;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.MissionParticipantDTO;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.Pagination;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.ParticipantDTO;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission_participant.adminnotes;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission_participant.index;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission_participant.list;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission_participant.previous;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission_participant.statusnotes;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.mission_participant.viewajax;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONException;
import org.json.JSONObject;

@SessionScoped
public class MissionParticipantController {
    static final int NUMBER_RECORDS = 10;
    OrganizationService organizationService;
    IdentityManager identityManager;
    IService missionParticipantService;
    @Inject
    LoginController loginController;
    @Inject
    @Path(value="mission_participant/index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="mission_participant/list.gtmpl")
    list listTpl;
    @Inject
    @Path(value="mission_participant/viewajax.gtmpl")
    viewajax viewAjaxTpl;
    @Inject
    @Path(value="mission_participant/previous.gtmpl")
    previous previousTPL;
    @Inject
    @Path(value="mission_participant/adminnotes.gtmpl")
    adminnotes adminNotesTpl;
    @Inject
    @Path(value="mission_participant/statusnotes.gtmpl")
    statusnotes statusNotesTpl;

    @Inject
    public MissionParticipantController(OrganizationService organizationService, IdentityManager identityManager, IService iService) {
        this.organizationService = organizationService;
        this.identityManager = identityManager;
        this.missionParticipantService = iService;
    }

    @Ajax
    @Resource
    public Response indexMP() {
        return this.indexTpl.with().set("states", (Object)Status.values()).ok();
    }

    public Response list() {
        String programId = this.loginController.getCurrentProgramId();
        List missionParticipants = this.missionParticipantService.getAllMissionParticipantsInProgram(programId);
        List missionParticipantDTOs = this.transfers2DTOs(missionParticipants);
        return this.listTpl.with().set("missionParticipantDTOs", (Object)missionParticipantDTOs).set("states", (Object)Status.values()).ok();
    }

    @View
    public Response view(String missionParticipantId) {
        return this.detail(missionParticipantId, Boolean.valueOf(false));
    }

    @Ajax
    @Resource
    public Response loadDetail(String missionParticipantId) {
        return this.detail(missionParticipantId, Boolean.valueOf(true));
    }

    private Response detail(String missionParticipantId, Boolean isAjax) {
        MissionParticipant missionParticipant = this.missionParticipantService.getMissionParticipantById(missionParticipantId);
        if (null != missionParticipant) {
            try {
                Mission mission = this.missionParticipantService.getMissionById(missionParticipant.getMission_id());
                if (null != mission) {
                    Identity identity = this.identityManager.getOrCreateIdentity("organization", missionParticipant.getParticipant_username(), true);
                    String fullname = missionParticipant.getParticipant_username();
                    String avatar = "";
                    String profileUrl = "";
                    String email = missionParticipant.getParticipant_username();
                    if (null != identity) {
                        fullname = identity.getProfile().getFullName();
                        avatar = identity.getProfile().getAvatarUrl();
                        profileUrl = identity.getProfile().getUrl();
                        email = identity.getProfile().getEmail();
                    }
                    MissionParticipantDTO missionParticipantDTO = new MissionParticipantDTO();
                    missionParticipantDTO.setId(missionParticipantId);
                    missionParticipantDTO.setMission_title(mission.getTitle() + " on " + mission.getThird_part_link());
                    if (this.loginController.isAdmin().booleanValue()) {
                        missionParticipantDTO.setMission_id(mission.getId());
                    }
                    missionParticipantDTO.setSize(missionParticipant.getSize().getLabel());
                    missionParticipantDTO.setDate_submitted(Utils.convertDateFromLong((Long)missionParticipant.getModifiedDate()));
                    missionParticipantDTO.setStatus(missionParticipant.getStatus());
                    missionParticipantDTO.setUrl_submitted(missionParticipant.getUrl_submitted());
                    ParticipantDTO participantDTO = new ParticipantDTO();
                    participantDTO.setUserName(missionParticipant.getParticipant_username());
                    participantDTO.setFullName(fullname);
                    participantDTO.setUrlAvatar(avatar);
                    participantDTO.setUrlProfile(profileUrl);
                    participantDTO.setEmail(email);
                    Address address = this.missionParticipantService.getAddressById(missionParticipant.getAddress_id());
                    if (null == address) {
                        address = new Address("", "", "", "", "", "");
                    }
                    AddressDTO addressDTO = new AddressDTO(address.getfName(), address.getlName(), address.getAddress(), address.getCity(), address.getCountry(), address.getPhone());
                    if (isAjax.booleanValue()) {
                        return this.viewAjaxTpl.with().set("missionParticipantDTO", (Object)missionParticipantDTO).set("address", (Object)addressDTO).set("participantDTO", (Object)participantDTO).set("states", (Object)Status.values()).ok();
                    }
                }
            }
            catch (Exception e) {
                return Response.ok((CharSequence)"nok");
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response.Content search(String keyword, String status, String page) {
        String programId = this.loginController.getCurrentProgramId();
        Query query = new Query(programId);
        query.setKeyword(keyword);
        query.setStatus(status);
        query.setOffset(page);
        query.setLimit(10);
        List missionParticipants = this.missionParticipantService.searchMissionParticipants(query);
        List missionParticipantDTOs = this.transfers2DTOs(missionParticipants);
        Pagination pagination = new Pagination(this.missionParticipantService.getTotalMissionParticipants(query), 10, page);
        return this.listTpl.with().set("missionParticipantDTOs", (Object)missionParticipantDTOs).set("states", (Object)Status.values()).set("pagination", (Object)pagination).ok();
    }

    @Ajax
    @Resource
    public Response ajaxUpdateMPInline(String missionParticipantId, String action, String val, String note, String force) {
        Boolean showReason = false;
        JSONObject jsonObject = new JSONObject();
        Boolean hasError = true;
        String msg = "Something went wrong,cannot update status";
        int oldStatus = 0;
        String mpId = "";
        MissionParticipant missionParticipant = this.missionParticipantService.getMissionParticipantById(missionParticipantId);
        if (null != missionParticipant) {
            oldStatus = missionParticipant.getStatus().getValue();
            if (oldStatus == Integer.parseInt(val)) {
                hasError = false;
                msg = "Status has already been updated ";
                note = "";
            } else {
                hasError = false;
                if (this.loginController.isShippingManager().booleanValue()) {
                    if (Status.SHIPPED.getValue() != Integer.parseInt(val)) {
                        hasError = true;
                        msg = "you have no rights for this change";
                    }
                } else if (this.loginController.isValidator().booleanValue() && Status.VALIDATED.getValue() != Integer.parseInt(val)) {
                    hasError = true;
                    msg = "you have no rights for this change";
                }
                if ("".equals(force) && Status.REJECTED.getValue() == Integer.parseInt(val)) {
                    msg = "show_reason";
                    mpId = missionParticipant.getId();
                    showReason = true;
                }
                if (!showReason.booleanValue() && !hasError.booleanValue() && action.equals("status")) {
                    missionParticipant.setStatus(Status.getStatus((int)Integer.parseInt(val)));
                    missionParticipant = this.missionParticipantService.updateMissionParticipantInProgram(this.loginController.getCurrentProgramId(), missionParticipant);
                    if (null != missionParticipant) {
                        hasError = false;
                        msg = "Status has been successfully updated";
                        mpId = missionParticipant.getId();
                        oldStatus = Integer.parseInt(val);
                        if (Status.REJECTED.getValue() == Integer.parseInt(val) && this.missionParticipantService.removeMissionInParticipant(this.loginController.getCurrentProgramId(), this.loginController.getCurrentUserName(), missionParticipant.getMission_id()).booleanValue()) {
                            msg = "One mission has been rejected, participant can replay it";
                        }
                    }
                }
            }
        } else {
            hasError = true;
            msg = "mission participant does not exist any more";
        }
        try {
            jsonObject.put("error", (Object)hasError);
            jsonObject.put("msg", (Object)msg);
            jsonObject.put("status", oldStatus);
            jsonObject.put("mpId", (Object)mpId);
            jsonObject.put("note", (Object)note);
        }
        catch (JSONException e) {
            return Response.ok((CharSequence)"something went wrong");
        }
        return Response.ok((CharSequence)jsonObject.toString());
    }

    private List<MissionParticipantDTO> transfers2DTOs(List<MissionParticipant> missionParticipants) {
        ArrayList<MissionParticipantDTO> missionParticipantDTOs = new ArrayList<MissionParticipantDTO>();
        for (MissionParticipant missionParticipant : missionParticipants) {
            try {
                Mission mission;
                User exoUser = this.organizationService.getUserHandler().findUserByName(missionParticipant.getParticipant_username());
                String fullname = missionParticipant.getParticipant_username();
                if (null != exoUser) {
                    fullname = exoUser.getFirstName() + " " + exoUser.getLastName();
                }
                if (null == (mission = this.missionParticipantService.getMissionById(missionParticipant.getMission_id()))) continue;
                MissionParticipantDTO missionParticipantDTO = new MissionParticipantDTO();
                missionParticipantDTO.setId(missionParticipant.getId());
                missionParticipantDTO.setMission_title(mission.getTitle());
                missionParticipantDTO.setParticipant_fullName(fullname);
                missionParticipantDTO.setParticipant_id(missionParticipant.getParticipant_username());
                missionParticipantDTO.setStatus(missionParticipant.getStatus());
                missionParticipantDTO.setUrl_submitted(missionParticipant.getUrl_submitted());
                missionParticipantDTO.setDate_submitted(Utils.convertDateFromLong((Long)missionParticipant.getModifiedDate()));
                Address address = this.missionParticipantService.getAddressById(missionParticipant.getAddress_id());
                if (null != address) {
                    AddressDTO addressDTO = new AddressDTO(address.getfName(), address.getlName(), address.getAddress(), address.getCity(), address.getCountry(), address.getPhone());
                    missionParticipantDTO.setAddressDTO(addressDTO);
                }
                missionParticipantDTOs.add(missionParticipantDTO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return missionParticipantDTOs;
    }

    @Ajax
    @Resource
    public Response getPreviousMissionParticipant(String username) {
        String programId = this.loginController.getCurrentProgramId();
        List missionParticipants = this.missionParticipantService.getAllMissionParticipantsInProgramByParticipant(programId, username);
        ArrayList<MissionParticipantDTO> missionParticipantDTOs = new ArrayList<MissionParticipantDTO>();
        for (MissionParticipant missionParticipant : missionParticipants) {
            Mission mission = this.missionParticipantService.getMissionById(missionParticipant.getMission_id());
            if (null == mission) continue;
            MissionParticipantDTO missionParticipantDTO = new MissionParticipantDTO();
            missionParticipantDTO.setParticipant_id(username);
            missionParticipantDTO.setId(missionParticipant.getId());
            missionParticipantDTO.setMission_title(mission.getTitle());
            missionParticipantDTO.setDate_submitted(Utils.convertDateFromLong((Long)missionParticipant.getModifiedDate()));
            missionParticipantDTOs.add(missionParticipantDTO);
        }
        if (missionParticipantDTOs.size() > 0) {
            return this.previousTPL.with().set("missionParticipantDTOs", missionParticipantDTOs).ok();
        }
        return Response.ok((CharSequence)"have no previous mission");
    }

    @Ajax
    @Resource
    public Response removeMissionParticipant(String missionParticipantId) {
        if (this.loginController.isAdmin().booleanValue()) {
            MissionParticipant missionParticipant = this.missionParticipantService.getMissionParticipantById(missionParticipantId);
            if (null != missionParticipant) {
                String username = missionParticipant.getParticipant_username();
                if (this.missionParticipantService.removeMissionParticipantInParticipant(this.loginController.getCurrentProgramId(), username, missionParticipantId).booleanValue()) {
                    if (this.missionParticipantService.removeMissionParticipant(missionParticipantId).booleanValue()) {
                        return Response.ok((CharSequence)"ok");
                    }
                    return Response.ok((CharSequence)"Something went wrong, cannot remove this mission participant");
                }
                return Response.ok((CharSequence)"Something went wrong, cannot remove this mission participant in participant");
            }
            return Response.ok((CharSequence)"this mission participant does not exist anymore");
        }
        return Response.ok((CharSequence)"you have no rights to do this task");
    }

    @Ajax
    @Resource
    public Response addMPAdminNote(String mpId, String content) {
        if (this.loginController.isAdmin().booleanValue()) {
            if (null != this.addNote(NoteType.AdminComment, mpId, content)) {
                return Response.ok((CharSequence)"ok");
            }
            return Response.ok((CharSequence)"Something went wrong, cannot remove this mission participant");
        }
        return Response.ok((CharSequence)"you have no rights to do this task");
    }

    @Ajax
    @Resource
    public Response addMPStatusNote(String mpId, String content) {
        MissionParticipantNote missionParticipantNote = this.addNote(NoteType.RejectParcipantReason, mpId, content);
        if (null != missionParticipantNote) {
            return Response.ok((CharSequence)missionParticipantNote.getContent());
        }
        return Response.ok((CharSequence)"nok");
    }

    private MissionParticipantNote addNote(NoteType noteType, String mpId, String content) {
        MissionParticipantNote missionParticipantNote = new MissionParticipantNote(mpId);
        missionParticipantNote.setType(noteType);
        missionParticipantNote.setAuthor(this.loginController.getCurrentUserName());
        missionParticipantNote.setContent(content);
        return this.missionParticipantService.addNote2MissionParticipant(missionParticipantNote);
    }

    @Ajax
    @Resource
    public Response updateMPAdminNote(String mpId, String mpNoteId, String content) {
        MissionParticipantNote missionParticipantNote = this.missionParticipantService.getMPNoteById(mpNoteId);
        if (null != missionParticipantNote) {
            missionParticipantNote.setContent(content);
            missionParticipantNote.setAuthor(this.loginController.getCurrentUserName());
            missionParticipantNote = this.missionParticipantService.updateMPNote(missionParticipantNote);
        }
        if (null == missionParticipantNote) {
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)"ok");
    }

    @Ajax
    @Resource
    public Response getAllMPAdminNote(String mpId) {
        if (this.loginController.isAdmin().booleanValue()) {
            String action = "update";
            MissionParticipantNote missionParticipantNote = null;
            List notes = this.missionParticipantService.getAllMPNotesByType(mpId, NoteType.AdminComment.getValue());
            if (notes.size() == 0) {
                action = "add";
            } else {
                missionParticipantNote = (MissionParticipantNote)notes.get(0);
            }
            return this.adminNotesTpl.with().set("note", (Object)missionParticipantNote).set("mpId", (Object)mpId).set("action", (Object)action).ok();
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response loadPoupMPStatusReasonOption(String mpId) {
        if (this.loginController.isAdmin().booleanValue()) {
            return this.statusNotesTpl.with().set("mpId", (Object)mpId).set("mpStatus", (Object)Status.REJECTED.getValue()).ok();
        }
        return Response.ok((CharSequence)"nok");
    }
}

