/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.frontend;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.request.HttpContext;
import juzu.request.SecurityContext;
import org.exoplatform.brandadvocacy.model.Address;
import org.exoplatform.brandadvocacy.model.Mission;
import org.exoplatform.brandadvocacy.model.MissionParticipant;
import org.exoplatform.brandadvocacy.model.Participant;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.model.Proposition;
import org.exoplatform.brandadvocacy.model.Size;
import org.exoplatform.brandadvocacy.model.Status;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.brandadvocacy.service.Utils;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.discovery;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.index;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.process;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.start;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.stepContainer;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.terminate;
import org.exoplatform.community.brandadvocacy.portlet.frontend.templates.thankyou;
import org.json.JSONObject;

@SessionScoped
public class JuZFrontEndApplication {
    IService jcrService;
    String remoteUserName;
    String currentMissionParticipantId;
    String currentMissionParticipantStatus;
    String currentPropositionId;
    String currentMissionId;
    String currentProgramId;
    String currentProgramTitle;
    Boolean isFinished;
    String sizeOutOfStock;
    String bannerUrl;
    JSONObject currentSettings;
    @Inject
    @Path(value="index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="discovery.gtmpl")
    discovery discoveryTpl;
    @Inject
    @Path(value="stepContainer.gtmpl")
    stepContainer stepContainerTpl;
    @Inject
    @Path(value="start.gtmpl")
    start startTpl;
    @Inject
    @Path(value="process.gtmpl")
    process processTpl;
    @Inject
    @Path(value="terminate.gtmpl")
    terminate terminateTpl;
    @Inject
    @Path(value="thankyou.gtmpl")
    thankyou thankyouTpl;

    @Inject
    public JuZFrontEndApplication(IService iService) {
        this.jcrService = iService;
    }

    private void init() {
        this.currentMissionId = null;
        this.currentMissionParticipantId = null;
        this.currentPropositionId = null;
        this.currentMissionParticipantStatus = null;
        if (null == this.currentProgramId) {
            this.loadCurrentProgram();
        }
        if (null != this.currentProgramId) {
            this.getRandomMission();
        }
    }

    @View
    public Response.Content index(SecurityContext securityContext, HttpContext httpContext) {
        this.bannerUrl = "";
        this.isFinished = false;
        this.remoteUserName = securityContext.getUserPrincipal().getName();
        if (null != this.remoteUserName) {
            this.init();
            if (null != this.currentMissionId) {
                this.currentSettings = this.jcrService.getProgramSettings(this.currentProgramId);
                if (null != this.currentSettings) {
                    String banner_url = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"banner_url");
                    if (null != banner_url && !"".equals(banner_url)) {
                        this.bannerUrl = banner_url;
                    }
                    this.sizeOutOfStock = Utils.getAttrFromJson((JSONObject)this.currentSettings, (String)"size_out_of_stock");
                }
                if (!"".equals(this.bannerUrl) && !this.checkBannerUrl(this.bannerUrl).booleanValue()) {
                    this.bannerUrl = "";
                }
                return this.indexTpl.ok();
            }
        }
        return Response.ok((CharSequence)"");
    }

    private Boolean checkBannerUrl(String bannerUrl) {
        try {
            URL url = new URL(bannerUrl);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("HEAD");
            int responseCode = huc.getResponseCode();
            if (responseCode == 200) {
                return true;
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private Mission getRandomMission() {
        Mission mission = this.jcrService.getRandomMisson(this.currentProgramId, this.remoteUserName);
        if (null != mission) {
            this.currentMissionId = mission.getId();
            List propositions = mission.getPropositions();
            if (null != propositions && propositions.size() > 0) {
                this.currentPropositionId = ((Proposition)propositions.get(0)).getId();
                return mission;
            }
        }
        return null;
    }

    private void loadCurrentMission() {
        Mission mission;
        MissionParticipant missionParticipant = this.jcrService.getCurrentMissionParticipantByUserName(this.currentProgramId, this.remoteUserName);
        if (null != missionParticipant) {
            this.currentMissionParticipantId = missionParticipant.getId();
            this.currentMissionId = missionParticipant.getMission_id();
            this.currentMissionParticipantStatus = missionParticipant.getStatus().getLabel();
            this.currentPropositionId = missionParticipant.getProposition_id();
        } else if (null == this.currentMissionId && null == this.currentPropositionId && null != (mission = this.jcrService.getRandomMisson(this.currentProgramId, this.remoteUserName))) {
            this.currentMissionId = mission.getId();
            Proposition proposition = this.jcrService.getRandomProposition(this.currentMissionId);
            if (null != proposition) {
                this.currentPropositionId = proposition.getId();
            }
        }
    }

    private void loadCurrentProgram() {
        block0: {
            List programs = this.jcrService.getAllPrograms();
            Iterator i$ = programs.iterator();
            if (!i$.hasNext()) break block0;
            Program program = (Program)i$.next();
            this.currentProgramId = program.getId();
            this.currentProgramTitle = program.getTitle();
        }
    }

    public String checkSession() {
        String msg = "";
        if (null == this.remoteUserName || "".equals(this.remoteUserName)) {
            msg = "Your session has been expired, please refresh your browser";
        }
        return msg;
    }

    @Ajax
    @Resource
    public Response.Content initView() {
        if (null != this.currentMissionId && null != this.currentPropositionId) {
            if (null == this.currentMissionParticipantId) {
                if (!this.getOrCreateMissionParticipant(this.currentMissionId).booleanValue()) {
                    return Response.ok((CharSequence)"something went wrong, please come back later");
                }
                return this.startTpl.ok();
            }
            if (Status.OPEN.getLabel().equals(this.currentMissionParticipantStatus)) {
                Mission mission = this.getCurrentMission();
                return this.processTpl.with().set("mission", (Object)mission).ok();
            }
            if (Status.INPROGRESS.getLabel().equals(this.currentMissionParticipantStatus)) {
                return this.terminateTpl.with().set("sizes", (Object)Size.values()).ok();
            }
        }
        return Response.ok((CharSequence)"We are preparing next mission, please come back later");
    }

    @Ajax
    @Resource
    public Response.Content loadDiscoveryView() {
        if ("".equals(this.bannerUrl)) {
            this.bannerUrl = "/brand-advocacy-webapp/img/banner.png";
        }
        if ("".equals(this.currentProgramTitle)) {
            this.currentProgramTitle = "Discovery your mission";
        }
        return this.discoveryTpl.with().set("bannerUrl", (Object)this.bannerUrl).set("programTitle", (Object)this.currentProgramTitle).ok();
    }

    @Ajax
    @Resource
    public Response.Content loadStepContainerView() {
        return this.stepContainerTpl.ok();
    }

    @Ajax
    @Resource
    public Response.Content loadStartView() {
        if (null == this.currentMissionId || null == this.currentPropositionId) {
            return Response.ok((CharSequence)"We are preparing next mission, please come back later");
        }
        if (!this.getOrCreateMissionParticipant(this.currentMissionId).booleanValue()) {
            return Response.ok((CharSequence)"something went wrong, please come back later");
        }
        return this.startTpl.ok();
    }

    @Ajax
    @Resource
    public Response processStartMission() {
        String session = this.checkSession();
        if ("".equals(session)) {
            if (!this.getOrCreateMissionParticipant(this.currentMissionId).booleanValue()) {
                return Response.ok((CharSequence)"nok");
            }
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)session);
    }

    @Ajax
    @Resource
    public Response loadProcessView() {
        Mission missionRandom = this.getCurrentMission();
        if (null != missionRandom) {
            return this.processTpl.with().set("mission", (Object)missionRandom).ok();
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response loadTerminateView() {
        String[] out_of_stock = new String[]{};
        if (null != this.sizeOutOfStock && !"".equals(this.sizeOutOfStock)) {
            out_of_stock = this.sizeOutOfStock.split(",");
        }
        return this.terminateTpl.with().set("sizes", (Object)Size.values()).set("size_out_of_stock", (Object)out_of_stock).ok();
    }

    @Ajax
    @Resource
    public Response executeMission() {
        String session = this.checkSession();
        if ("".equals(session)) {
            MissionParticipant missionParticipant;
            if (null != this.currentMissionParticipantId && null != (missionParticipant = this.jcrService.getMissionParticipantById(this.currentMissionParticipantId))) {
                missionParticipant.setStatus(Status.INPROGRESS);
                if (null != this.jcrService.updateMissionParticipantInProgram(this.currentProgramId, missionParticipant)) {
                    this.currentMissionParticipantStatus = Status.INPROGRESS.getLabel();
                    return Response.ok((CharSequence)"ok");
                }
            }
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)session);
    }

    @Ajax
    @Resource
    public Response completeMission(String url, String fname, String lname, String address, String city, String phone, String country, String size) {
        String session = this.checkSession();
        if ("".equals(session)) {
            MissionParticipant missionParticipant;
            if (null != this.currentMissionParticipantId && null != (missionParticipant = this.jcrService.getMissionParticipantById(this.currentMissionParticipantId))) {
                missionParticipant.setProposition_id(this.currentPropositionId);
                Address addressObj = new Address(fname, lname, address, city, country, phone);
                addressObj = this.jcrService.addAddress2Participant(this.currentProgramId, this.remoteUserName, addressObj);
                if (null != addressObj) {
                    missionParticipant.setUrl_submitted(url);
                    missionParticipant.setStatus(Status.WAITING_FOR_VALIDATE);
                    missionParticipant.setAddress_id(addressObj.getId());
                    missionParticipant.setSize(Size.getSize((int)Integer.parseInt(size)));
                    if (null != this.jcrService.updateMissionParticipantInProgram(this.currentProgramId, missionParticipant)) {
                        Participant participant = new Participant(this.remoteUserName);
                        participant.setProgramId(this.currentProgramId);
                        HashSet<String> missionIds = new HashSet<String>();
                        missionIds.add(this.currentMissionId);
                        participant.setMission_ids(missionIds);
                        HashSet<String> missionParticipantIds = new HashSet<String>();
                        missionParticipantIds.add(this.currentMissionParticipantId);
                        participant.setMission_participant_ids(missionParticipantIds);
                        if (null != this.jcrService.addParticipant2Program(participant) && null != this.updateCurrentProposition()) {
                            return Response.ok((CharSequence)"ok");
                        }
                    }
                }
            }
            if (this.jcrService.removeMissionParticipantInParticipant(this.currentProgramId, this.remoteUserName, this.currentMissionParticipantId).booleanValue()) {
                this.jcrService.removeMissionParticipant(this.currentMissionParticipantId);
            }
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)session);
    }

    @Ajax
    @Resource
    public Response loadThankyouView() {
        return this.thankyouTpl.ok();
    }

    private Boolean getOrCreateMissionParticipant(String missionId) {
        MissionParticipant missionParticipant = this.jcrService.getCurrentMissionParticipantByMissionId(this.currentProgramId, missionId, this.remoteUserName);
        if (null == missionParticipant) {
            missionParticipant = new MissionParticipant();
            missionParticipant.setMission_id(missionId);
            missionParticipant.setParticipant_username(this.remoteUserName);
            missionParticipant = this.jcrService.addMissionParticipant2Program(this.currentProgramId, missionParticipant);
            if (null != missionParticipant) {
                Participant participant = new Participant(this.remoteUserName);
                participant.setProgramId(this.currentProgramId);
                HashSet missionIds = new HashSet();
                participant.setMission_ids(missionIds);
                HashSet<String> missionParticipantIds = new HashSet<String>();
                missionParticipantIds.add(missionParticipant.getId());
                participant.setMission_participant_ids(missionParticipantIds);
                if (null != this.jcrService.addParticipant2Program(participant)) {
                    this.currentMissionParticipantId = missionParticipant.getId();
                    this.currentMissionParticipantStatus = Status.OPEN.getLabel();
                    return true;
                }
                if (null == this.currentMissionParticipantId) {
                    this.jcrService.removeMissionParticipant(missionParticipant.getId());
                }
            }
        } else {
            this.currentMissionParticipantId = missionParticipant.getId();
            this.currentMissionParticipantStatus = Status.OPEN.getLabel();
            return true;
        }
        return false;
    }

    private Proposition updateCurrentProposition() {
        Proposition proposition = this.jcrService.getPropositionById(this.currentPropositionId);
        if (null != proposition) {
            proposition.setNumberUsed(proposition.getNumberUsed() + 1);
            return this.jcrService.updateProposition(proposition);
        }
        return null;
    }

    private Mission getCurrentMission() {
        Mission randomMission = null;
        Proposition randomProposition = null;
        if (null != this.currentMissionId) {
            ArrayList<Proposition> propositions = new ArrayList<Proposition>(1);
            randomMission = this.jcrService.getMissionById(this.currentMissionId);
            if (null != this.currentPropositionId && null != (randomProposition = this.jcrService.getPropositionById(this.currentPropositionId))) {
                propositions.add(randomProposition);
                randomMission.setPropositions(propositions);
                return randomMission;
            }
        }
        return null;
    }

    @Ajax
    @Resource
    public Response sendNotifEmail() {
        if (this.jcrService.sendNotifMissionParticipantEmail(this.currentSettings, this.currentMissionParticipantId, "").booleanValue()) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response sendNotifAlmostMissionDoneEmail() {
        if (this.jcrService.sendNotifAlmostMissionDoneEmail(this.currentProgramId, this.remoteUserName).booleanValue()) {
            return Response.ok((CharSequence)"ok");
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response generateNewMission() {
        String session = this.checkSession();
        if ("".equals(session)) {
            this.init();
            if (null != this.currentMissionId) {
                return Response.ok((CharSequence)"ok");
            }
            return Response.ok((CharSequence)"nok");
        }
        return Response.ok((CharSequence)session);
    }
}

