/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.brandadvocacy.portlet.backend.controllers;

import javax.inject.Inject;
import juzu.Mapped;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.plugin.ajax.Ajax;
import org.exoplatform.brandadvocacy.model.Manager;
import org.exoplatform.brandadvocacy.model.Program;
import org.exoplatform.brandadvocacy.model.Size;
import org.exoplatform.brandadvocacy.service.IService;
import org.exoplatform.brandadvocacy.service.Utils;
import org.exoplatform.community.brandadvocacy.portlet.backend.controllers.LoginController;
import org.exoplatform.community.brandadvocacy.portlet.backend.models.Settings;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.program.add;
import org.exoplatform.community.brandadvocacy.portlet.backend.templates.program.index;
import org.exoplatform.services.organization.OrganizationService;
import org.json.JSONException;
import org.json.JSONObject;

@SessionScoped
public class ProgramController {
    @Inject
    @Path(value="program/index.gtmpl")
    index indexTpl;
    @Inject
    @Path(value="program/add.gtmpl")
    add addTpl;
    OrganizationService organizationService;
    IService jcrService;
    @Inject
    LoginController loginController;

    @Inject
    public ProgramController(OrganizationService organizationService, IService iService) {
        this.organizationService = organizationService;
        this.jcrService = iService;
    }

    @Ajax
    @Resource
    public Response index() {
        String banner_url = "";
        String email_sender = "";
        String manager_name = "";
        String manager_title = "";
        String size_out_of_stock = "";
        String save_user_data_endpoint = "";
        String save_user_data_endpoint_token = "";
        String save_user_data_request_method = "";
        String facebook_oauth_url = "";
        String google_oauth_url = "";
        String linkedin_oauth_url = "";
        String facebook_share_url = "";
        String google_share_url = "";
        String linkedin_share_url = "";
        Program program = null;
        String programId = this.loginController.getCurrentProgramId();
        if (null != programId) {
            program = this.jcrService.getProgramById(programId);
        }
        if (null != program) {
            JSONObject settings = this.jcrService.getProgramSettings(programId);
            if (null != settings) {
                banner_url = Utils.getAttrFromJson((JSONObject)settings, (String)"banner_url");
                email_sender = Utils.getAttrFromJson((JSONObject)settings, (String)"email_sender");
                manager_name = Utils.getAttrFromJson((JSONObject)settings, (String)"manager_name");
                manager_title = Utils.getAttrFromJson((JSONObject)settings, (String)"manager_title");
                size_out_of_stock = Utils.getAttrFromJson((JSONObject)settings, (String)"size_out_of_stock");
                save_user_data_endpoint = Utils.getAttrFromJson((JSONObject)settings, (String)"save_user_data_endpoint");
                save_user_data_endpoint_token = Utils.getAttrFromJson((JSONObject)settings, (String)"save_user_data_endpoint_token");
                save_user_data_request_method = Utils.getAttrFromJson((JSONObject)settings, (String)"save_user_data_request_method");
                facebook_oauth_url = Utils.getAttrFromJson((JSONObject)settings, (String)"facebook_oauth_url");
                google_oauth_url = Utils.getAttrFromJson((JSONObject)settings, (String)"google_oauth_url");
                linkedin_oauth_url = Utils.getAttrFromJson((JSONObject)settings, (String)"linkedin_oauth_url");
                facebook_share_url = Utils.getAttrFromJson((JSONObject)settings, (String)"facebook_share_url");
                google_share_url = Utils.getAttrFromJson((JSONObject)settings, (String)"google_share_url");
                linkedin_share_url = Utils.getAttrFromJson((JSONObject)settings, (String)"linkedin_share_url");
            }
            String[] out_of_stock = size_out_of_stock.split(",");
            return this.indexTpl.with().set("program", (Object)program).set("banner_url", (Object)banner_url).set("email_sender", (Object)email_sender).set("sizes", (Object)Size.values()).set("size_out_of_stock", (Object)out_of_stock).set("save_user_data_endpoint", (Object)save_user_data_endpoint).set("save_user_data_endpoint_token", (Object)save_user_data_endpoint_token).set("save_user_data_request_method", (Object)save_user_data_request_method).set("manager_name", (Object)manager_name).set("manager_title", (Object)manager_title).set("facebook_oauth_url", (Object)facebook_oauth_url).set("google_oauth_url", (Object)google_oauth_url).set("linkedin_oauth_url", (Object)linkedin_oauth_url).set("facebook_share_url", (Object)facebook_share_url).set("google_share_url", (Object)google_share_url).set("linkedin_share_url", (Object)linkedin_share_url).ok();
        }
        return this.addTpl.ok();
    }

    @Ajax
    @Resource
    public Response add(String title) {
        Program program = new Program(title);
        if (null != (program = this.jcrService.addProgram(program))) {
            Manager manager = new Manager(this.loginController.getCurrentUserName());
            manager.setParentId(program.getId());
            if (null != this.jcrService.addManager2Program(manager)) {
                this.loginController.setCurrentProgramId(program.getId());
                return Response.ok((CharSequence)program.getId());
            }
        }
        return Response.ok((CharSequence)"nok");
    }

    @Ajax
    @Resource
    public Response update(@Mapped Settings settingsBean) {
        String title = settingsBean.title;
        String banner_url = settingsBean.banner_url;
        String email_sender = settingsBean.email_sender;
        String manager_name = settingsBean.manager_name;
        String manager_title = settingsBean.manager_title;
        String size_out_of_stock = settingsBean.size_out_of_stock;
        String save_user_data_endpoint = settingsBean.save_user_data_endpoint;
        String save_user_data_endpoint_token = settingsBean.save_user_data_endpoint_token;
        String save_user_data_request_method = settingsBean.save_user_data_request_method;
        String facebook_oauth_url = settingsBean.facebook_oauth_url;
        String google_oauth_url = settingsBean.google_oauth_url;
        String linkedin_oauth_url = settingsBean.linkedin_oauth_url;
        String facebook_share_url = settingsBean.facebook_share_url;
        String google_share_url = settingsBean.google_share_url;
        String linkedin_share_url = settingsBean.linkedin_share_url;
        String programId = this.loginController.getCurrentProgramId();
        Program program = this.jcrService.getProgramById(programId);
        if (null != program) {
            program.setTitle(title);
            if (null != this.jcrService.updateProgram(program)) {
                JSONObject settings = new JSONObject();
                try {
                    if (null == banner_url) {
                        banner_url = "";
                    }
                    if (null == email_sender) {
                        email_sender = "";
                    }
                    if (null == manager_name) {
                        manager_name = "";
                    }
                    if (null == manager_title) {
                        manager_title = "";
                    }
                    if (null == facebook_oauth_url) {
                        facebook_oauth_url = "";
                    }
                    if (null == google_oauth_url) {
                        google_oauth_url = "";
                    }
                    if (null == linkedin_oauth_url) {
                        linkedin_oauth_url = "";
                    }
                    if (null == facebook_share_url) {
                        facebook_share_url = "";
                    }
                    if (null == google_share_url) {
                        google_oauth_url = "";
                    }
                    if (null == linkedin_share_url) {
                        linkedin_share_url = "";
                    }
                    settings.put("banner_url", (Object)banner_url);
                    settings.put("email_sender", (Object)email_sender);
                    settings.put("manager_name", (Object)manager_name);
                    settings.put("manager_title", (Object)manager_title);
                    if (null == size_out_of_stock) {
                        size_out_of_stock = "";
                    }
                    settings.put("size_out_of_stock", (Object)size_out_of_stock);
                    settings.put("save_user_data_endpoint", (Object)save_user_data_endpoint);
                    settings.put("save_user_data_endpoint_token", (Object)save_user_data_endpoint_token);
                    settings.put("save_user_data_request_method", (Object)save_user_data_request_method);
                    settings.put("facebook_oauth_url", (Object)facebook_oauth_url);
                    settings.put("google_oauth_url", (Object)google_oauth_url);
                    settings.put("linkedin_oauth_url", (Object)linkedin_oauth_url);
                    settings.put("facebook_share_url", (Object)facebook_share_url);
                    settings.put("google_share_url", (Object)google_share_url);
                    settings.put("linkedin_share_url", (Object)linkedin_share_url);
                    program.setSettings(settings);
                    this.jcrService.setProgramSettings(program);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return Response.ok((CharSequence)"The program has been updated");
            }
        }
        return Response.ok((CharSequence)"nok");
    }
}

